/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.dinkmaker;

import com.adonax.dinkmaker.AboutBox;
import com.adonax.dinkmaker.DinkPlayer;
import com.adonax.dinkmaker.HelpBox;
import com.adonax.pfaudio.midi.PitchFunctions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Properties;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DinkLauncher
extends Application
implements EventHandler<KeyEvent> {
    private Stage primaryStage;
    private DinkPlayer player;
    private String fileName;
    private double carrierHz;
    private float carrierPB;
    private int riseFallCarrierPB = 1;
    private double lfoFrequency;
    private double lfoAmplitude;
    private DinkPlayer.SynthMode lfoSynthMode = DinkPlayer.SynthMode.LFO_VIBRATO;
    private int riseFallLFOSweep = 1;
    private float lfoSweep;
    private DinkPlayer.SynthMode synthMode = DinkPlayer.SynthMode.ABSOLUTE;
    private double modulatorHzFactor;
    private double sbModulatorIndexValue;
    private float modIdxSweep;
    private int riseFallModIdxSweep = 1;
    private boolean modUseEnv = false;
    private int sbEnvOnsetValue;
    private int sbEnvSustainValue;
    private int sbEnvReleaseValue;
    private TextField txtFileName;
    private ScrollBar sbCarrierFrequency;
    private RadioButton rbCarrierPBNone;
    private RadioButton rbCarrierPBRise;
    private RadioButton rbCarrierPBFall;
    private ScrollBar sbCarrierPBAmount;
    private RadioButton rbLFOVibrato;
    private RadioButton rbLFOTremolo;
    private ScrollBar sbLFOFrequency;
    private ScrollBar sbLFOAmplitude;
    private ScrollBar sbLFOFreqSweepAmount;
    private RadioButton rbLFOFreqSweepNone;
    private RadioButton rbLFOFreqSweepRise;
    private RadioButton rbLFOFreqSweepFall;
    private RadioButton rbModPMAbsolute;
    private RadioButton rbModPMRelative;
    private ScrollBar sbModulatorFrequency;
    private ScrollBar sbModIndexAmplitude;
    private ScrollBar sbModIndexEnvAmount;
    private RadioButton rbModIndexEnvStatic;
    private RadioButton rbModIndexEnvParallel;
    private RadioButton rbModIndexEnvRise;
    private RadioButton rbModIndexEnvFall;
    private ScrollBar sbEnvOnset;
    private ScrollBar sbEnvSustain;
    private ScrollBar sbEnvRelease;
    private NumberFormat decimal2places;
    private NumberFormat decimal3places;
    private Properties props;
    private File propsFile;
    private boolean propertiesChanged;
    private File defaultFileDirectory;

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public void start(Stage primaryStage) throws UnsupportedAudioFileException, IOException {
        this.decimal3places = DecimalFormat.getInstance();
        this.decimal3places.setMinimumFractionDigits(3);
        this.decimal3places.setMaximumFractionDigits(3);
        this.decimal3places.setRoundingMode(RoundingMode.HALF_EVEN);
        this.decimal2places = DecimalFormat.getInstance();
        this.decimal2places.setMinimumFractionDigits(2);
        this.decimal2places.setMaximumFractionDigits(2);
        this.decimal2places.setRoundingMode(RoundingMode.HALF_EVEN);
        this.props = new Properties();
        String userDir = System.getProperty("user.home");
        this.propsFile = new File(String.valueOf(userDir) + "/.dinkmaker");
        if (!this.propsFile.exists()) {
            this.props = new Properties();
            this.props.setProperty("dirLastUsed", userDir);
            FileOutputStream out = new FileOutputStream(this.propsFile);
            this.props.store(out, "dinkmaker properties");
            out.flush();
            out.close();
            System.out.println("New properties file created at: " + this.propsFile.getAbsolutePath());
        } else {
            FileInputStream inStream = new FileInputStream(this.propsFile);
            this.props.load(inStream);
        }
        this.defaultFileDirectory = new File(this.props.getProperty("dirLastUsed"));
        this.primaryStage = primaryStage;
        primaryStage.setTitle("Dink Maker 0.1");
        Group root = new Group();
        Scene scene = new Scene((Parent)root, 550.0, 500.0);
        this.player = new DinkPlayer();
        Label lblFileName = new Label("Patch Name: ");
        this.txtFileName = new TextField();
        this.txtFileName.setMinWidth(100.0);
        HBox hbFileName = new HBox();
        hbFileName.setSpacing(6.0);
        hbFileName.getChildren().addAll((Object[])new Node[]{lblFileName, this.txtFileName});
        Label lbCarrierFrequency = new Label("Carrier Frequency");
        lbCarrierFrequency.setMinSize(100.0, 10.0);
        Label lblCarrierFrequencyValue = new Label("0");
        lblCarrierFrequencyValue.setMinSize(12.0, 10.0);
        lblCarrierFrequencyValue.setStyle("-fx-text-fill: brown;");
        this.sbCarrierFrequency = new ScrollBar();
        this.sbCarrierFrequency.setOrientation(Orientation.HORIZONTAL);
        this.sbCarrierFrequency.setMax(1200.0);
        this.sbCarrierFrequency.valueProperty().addListener((observable, oldvalue, newvalue) -> {
            double midi = (double)newvalue.intValue() / 10.0;
            this.carrierHz = PitchFunctions.getHertzFromMidi(midi);
            this.player.updateParameter(DinkPlayer.Parameter.CARRIER_FREQUENCY, (float)this.carrierHz);
            lblCarrierFrequencyValue.setText("Midi: " + this.decimal2places.format(midi) + ", Hz: " + this.decimal2places.format(this.carrierHz));
        });
        HBox hbCarrierFrequency = new HBox();
        hbCarrierFrequency.setSpacing(6.0);
        hbCarrierFrequency.getChildren().addAll((Object[])new Node[]{lbCarrierFrequency, this.sbCarrierFrequency, lblCarrierFrequencyValue});
        Label lbCarrierPB = new Label("Carrier Pitchbend");
        Label lblCarrierPBValue = new Label("");
        lblCarrierPBValue.setMinSize(12.0, 10.0);
        lblCarrierPBValue.setStyle("-fx-text-fill: brown;");
        ToggleGroup tgCarrierPB = new ToggleGroup();
        this.sbCarrierPBAmount = new ScrollBar();
        this.sbCarrierPBAmount.valueProperty().addListener((observable, oldvalue, newvalue) -> {
            this.carrierPB = newvalue.floatValue() / 100.0f;
            this.player.updateParameter(DinkPlayer.Parameter.CARRIER_PITCHBEND, this.carrierPB * (float)this.riseFallCarrierPB);
            lblCarrierPBValue.setText(this.decimal2places.format(this.carrierPB * (float)this.riseFallCarrierPB));
        });
        this.rbCarrierPBNone = new RadioButton("None");
        this.rbCarrierPBNone.setToggleGroup(tgCarrierPB);
        this.rbCarrierPBNone.setOnAction(e -> {
            this.sbCarrierPBAmount.setDisable(true);
            this.player.updateParameter(DinkPlayer.Parameter.CARRIER_PITCHBEND, 0.0f);
            lblCarrierPBValue.setText("");
        });
        this.rbCarrierPBRise = new RadioButton("Rise");
        this.rbCarrierPBRise.setToggleGroup(tgCarrierPB);
        this.rbCarrierPBRise.setOnAction(e -> {
            this.sbCarrierPBAmount.setDisable(false);
            this.riseFallCarrierPB = 1;
            this.player.updateParameter(DinkPlayer.Parameter.CARRIER_PITCHBEND, this.carrierPB);
            this.sbCarrierPBAmount.getValue();
            lblCarrierPBValue.setText(this.decimal2places.format(this.carrierPB * (float)this.riseFallCarrierPB));
        });
        this.rbCarrierPBFall = new RadioButton("Fall, ");
        this.rbCarrierPBFall.setToggleGroup(tgCarrierPB);
        this.rbCarrierPBFall.setOnAction(e -> {
            this.sbCarrierPBAmount.setDisable(false);
            this.riseFallCarrierPB = -1;
            this.player.updateParameter(DinkPlayer.Parameter.CARRIER_PITCHBEND, this.carrierPB * -1.0f);
            this.sbCarrierPBAmount.getValue();
            lblCarrierPBValue.setText(this.decimal2places.format(this.carrierPB * (float)this.riseFallCarrierPB));
        });
        HBox hbCarrierPB = new HBox();
        hbCarrierPB.setSpacing(10.0);
        hbCarrierPB.getChildren().addAll((Object[])new Node[]{lbCarrierPB, this.rbCarrierPBNone, this.rbCarrierPBRise, this.rbCarrierPBFall, this.sbCarrierPBAmount, lblCarrierPBValue});
        this.sbLFOAmplitude = new ScrollBar();
        Label lblLFOAmplitudeValue = new Label("0");
        Label lbLFOMode = new Label("LFO,  Mode:");
        Label lblLFOPitch = new Label("Freq:");
        this.sbLFOFrequency = new ScrollBar();
        this.sbLFOFrequency.setOrientation(Orientation.HORIZONTAL);
        this.sbLFOFrequency.setMax(900.0);
        Label lblLFOFrequencyValue = new Label("0");
        lblLFOFrequencyValue.setMinSize(12.0, 10.0);
        lblLFOFrequencyValue.setStyle("-fx-text-fill: brown;");
        this.sbLFOFrequency.valueProperty().addListener((observable, oldvalue, newvalue) -> {
            double valueRange = (double)(newvalue.intValue() + 100) / 100.0;
            this.lfoFrequency = valueRange * valueRange;
            this.player.updateParameter(DinkPlayer.Parameter.LFO_FREQUENCY, (float)this.lfoFrequency);
            lblLFOFrequencyValue.setText("Hz: " + this.decimal2places.format(this.lfoFrequency));
        });
        this.rbLFOVibrato = new RadioButton("Vibrato");
        ToggleGroup tgLFOMode = new ToggleGroup();
        this.rbLFOVibrato.setToggleGroup(tgLFOMode);
        this.rbLFOVibrato.setOnAction(e -> {
            this.lfoSynthMode = DinkPlayer.SynthMode.LFO_VIBRATO;
            this.player.setSynthMode(this.lfoSynthMode);
            this.sbLFOAmplitude.setDisable(false);
            lblLFOAmplitudeValue.setText(this.decimal2places.format(this.lfoAmplitude));
        });
        this.rbLFOTremolo = new RadioButton("Tremolo,");
        this.rbLFOTremolo.setToggleGroup(tgLFOMode);
        this.rbLFOTremolo.setOnAction(e -> {
            this.lfoSynthMode = DinkPlayer.SynthMode.LFO_TREMOLO;
            this.player.setSynthMode(this.lfoSynthMode);
            this.sbLFOAmplitude.setDisable(true);
            lblLFOAmplitudeValue.setText("1.00");
        });
        HBox hbLFOFrequency = new HBox();
        hbLFOFrequency.setSpacing(10.0);
        hbLFOFrequency.getChildren().addAll((Object[])new Node[]{lbLFOMode, this.rbLFOVibrato, this.rbLFOTremolo, lblLFOPitch, this.sbLFOFrequency, lblLFOFrequencyValue});
        Label lbLFOAmplitude = new Label("LFO Amplitude");
        lblLFOAmplitudeValue.setMinSize(12.0, 10.0);
        lblLFOAmplitudeValue.setStyle("-fx-text-fill: brown;");
        Label lblLFOAmplitudeLow = new Label("None");
        lblLFOAmplitudeLow.setMinSize(30.0, 10.0);
        lblLFOAmplitudeLow.setStyle("-fx-text-fill: blue;");
        Label lblLFOAmplitudeHigh = new Label("High");
        lblLFOAmplitudeHigh.setMinSize(30.0, 10.0);
        lblLFOAmplitudeHigh.setStyle("-fx-text-fill: blue;");
        this.sbLFOAmplitude.setMax(100.0);
        this.sbLFOAmplitude.valueProperty().addListener((observable, oldvalue, newvalue) -> {
            this.lfoAmplitude = (float)newvalue.intValue() / 100.0f;
            this.player.updateParameter(DinkPlayer.Parameter.LFO_AMPLITUDE, (float)this.lfoAmplitude);
            lblLFOAmplitudeValue.setText(this.decimal2places.format(this.lfoAmplitude));
        });
        HBox hbLFOAmplitude = new HBox();
        hbLFOAmplitude.setSpacing(10.0);
        hbLFOAmplitude.getChildren().addAll((Object[])new Node[]{lbLFOAmplitude, lblLFOAmplitudeLow, this.sbLFOAmplitude, lblLFOAmplitudeValue, lblLFOAmplitudeHigh});
        Label lbLFOFreqSweep = new Label("LFO Freq Sweep: ");
        Label lblLFOFreqSweepValue = new Label("");
        lblLFOFreqSweepValue.setMinSize(12.0, 10.0);
        lblLFOFreqSweepValue.setStyle("-fx-text-fill: brown;");
        this.sbLFOFreqSweepAmount = new ScrollBar();
        this.sbLFOFreqSweepAmount.valueProperty().addListener((observable, oldvalue, newvalue) -> {
            System.out.println("SBLFOSweep.newvalue:" + newvalue.floatValue());
            this.lfoSweep = newvalue.floatValue() / 100.0f;
            this.player.updateParameter(DinkPlayer.Parameter.LFO_SWEEP, this.lfoSweep * (float)this.riseFallLFOSweep);
            lblLFOFreqSweepValue.setText(this.decimal2places.format(this.lfoSweep * (float)this.riseFallLFOSweep));
        });
        ToggleGroup tgLFOFreqSweep = new ToggleGroup();
        this.rbLFOFreqSweepNone = new RadioButton("None");
        this.rbLFOFreqSweepNone.setToggleGroup(tgLFOFreqSweep);
        this.rbLFOFreqSweepNone.setOnAction(e -> {
            this.sbLFOFreqSweepAmount.setDisable(true);
            this.player.setModToUseCarrierEnv(false);
            this.player.updateParameter(DinkPlayer.Parameter.LFO_SWEEP, 0.0f);
            lblLFOFreqSweepValue.setText("");
        });
        this.rbLFOFreqSweepRise = new RadioButton("Rise");
        this.rbLFOFreqSweepRise.setToggleGroup(tgLFOFreqSweep);
        this.rbLFOFreqSweepRise.setOnAction(e -> {
            this.sbLFOFreqSweepAmount.setDisable(false);
            this.riseFallLFOSweep = 1;
            this.player.setModToUseCarrierEnv(false);
            this.player.updateParameter(DinkPlayer.Parameter.LFO_SWEEP, this.lfoSweep);
            lblLFOFreqSweepValue.setText(this.decimal2places.format(this.lfoSweep * (float)this.riseFallLFOSweep));
        });
        this.rbLFOFreqSweepFall = new RadioButton("Fall, ");
        this.rbLFOFreqSweepFall.setToggleGroup(tgLFOFreqSweep);
        this.rbLFOFreqSweepFall.setOnAction(e -> {
            this.sbLFOFreqSweepAmount.setDisable(false);
            this.riseFallLFOSweep = -1;
            this.player.setModToUseCarrierEnv(false);
            this.player.updateParameter(DinkPlayer.Parameter.LFO_SWEEP, this.lfoSweep * -1.0f);
            lblLFOFreqSweepValue.setText(this.decimal2places.format(this.lfoSweep * (float)this.riseFallLFOSweep));
        });
        HBox hbLFOFreqSweep = new HBox();
        hbLFOFreqSweep.setSpacing(10.0);
        hbLFOFreqSweep.getChildren().addAll((Object[])new Node[]{lbLFOFreqSweep, this.rbLFOFreqSweepNone, this.rbLFOFreqSweepRise, this.rbLFOFreqSweepFall, this.sbLFOFreqSweepAmount, lblLFOFreqSweepValue});
        Label lbModulatorMode = new Label("Modulator, Mode:");
        Label lblModulatorPitch = new Label("Freq:");
        this.sbModulatorFrequency = new ScrollBar();
        this.sbModulatorFrequency.setOrientation(Orientation.HORIZONTAL);
        this.sbModulatorFrequency.setMax(1200.0);
        Label lblModulatorFrequencyValue = new Label("0");
        lblModulatorFrequencyValue.setMinSize(12.0, 10.0);
        lblModulatorFrequencyValue.setStyle("-fx-text-fill: brown;");
        this.sbModulatorFrequency.valueProperty().addListener((observable, oldvalue, newvalue) -> this.sbModulatorFrequencyListener(newvalue.intValue(), lblModulatorFrequencyValue));
        ToggleGroup tgModPitchMode = new ToggleGroup();
        this.rbModPMAbsolute = new RadioButton("Abs");
        this.rbModPMAbsolute.setToggleGroup(tgModPitchMode);
        this.rbModPMAbsolute.setOnAction(e -> {
            this.synthMode = DinkPlayer.SynthMode.ABSOLUTE;
            this.player.setSynthMode(this.synthMode);
            this.sbModulatorFrequencyListener(this.sbModulatorFrequency.getValue(), lblModulatorFrequencyValue);
        });
        this.rbModPMRelative = new RadioButton("Rel,");
        this.rbModPMRelative.setToggleGroup(tgModPitchMode);
        this.rbModPMRelative.setOnAction(e -> {
            this.synthMode = DinkPlayer.SynthMode.RELATIVE;
            this.player.setSynthMode(this.synthMode);
            this.sbModulatorFrequencyListener(this.sbModulatorFrequency.getValue(), lblModulatorFrequencyValue);
        });
        HBox hbModulatorPB = new HBox();
        hbModulatorPB.setSpacing(10.0);
        hbModulatorPB.getChildren().addAll((Object[])new Node[]{lbModulatorMode, this.rbModPMAbsolute, this.rbModPMRelative, lblModulatorPitch, this.sbModulatorFrequency, lblModulatorFrequencyValue});
        Label lblModIndexAmplitude = new Label("Modulation Amplitude");
        Label lblModIndexValue = new Label("0");
        lblModIndexValue.setMinSize(12.0, 10.0);
        lblModIndexValue.setStyle("-fx-text-fill: brown;");
        Label lblModIndexLow = new Label("None");
        lblModIndexLow.setMinSize(30.0, 10.0);
        lblModIndexLow.setStyle("-fx-text-fill: blue;");
        Label lblModIndexHigh = new Label("High");
        lblModIndexHigh.setMinSize(30.0, 10.0);
        lblModIndexHigh.setStyle("-fx-text-fill: blue;");
        this.sbModIndexAmplitude = new ScrollBar();
        this.sbModIndexAmplitude.setMax(1000.0);
        this.sbModIndexAmplitude.valueProperty().addListener((observable, oldvalue, newvalue) -> {
            this.sbModulatorIndexValue = (double)newvalue.intValue() / 1000.0;
            this.player.updateParameter(DinkPlayer.Parameter.MODULATOR_INDEX, (float)this.sbModulatorIndexValue);
            lblModIndexValue.setText(String.valueOf(this.decimal3places.format(this.sbModulatorIndexValue)));
        });
        HBox hbModIndexAmplitude = new HBox();
        hbModIndexAmplitude.setSpacing(10.0);
        hbModIndexAmplitude.getChildren().addAll((Object[])new Node[]{lblModIndexAmplitude, lblModIndexLow, this.sbModIndexAmplitude, lblModIndexValue, lblModIndexHigh});
        Label lbModIndexEnv = new Label("Mod Amp Env Mode:");
        Label lblModIndexEnvValue = new Label("");
        lblModIndexEnvValue.setMinSize(12.0, 10.0);
        lblModIndexEnvValue.setStyle("-fx-text-fill: brown;");
        this.sbModIndexEnvAmount = new ScrollBar();
        this.sbModIndexEnvAmount.valueProperty().addListener((observable, oldvalue, newvalue) -> {
            this.modIdxSweep = newvalue.floatValue() / 100.0f;
            this.player.updateParameter(DinkPlayer.Parameter.MODULATOR_INDEX_SWEEP, this.modIdxSweep * (float)this.riseFallModIdxSweep);
            lblModIndexEnvValue.setText(this.decimal3places.format(this.modIdxSweep * (float)this.riseFallModIdxSweep));
        });
        ToggleGroup tgModIndexEnv = new ToggleGroup();
        this.rbModIndexEnvStatic = new RadioButton("Static");
        this.rbModIndexEnvStatic.setToggleGroup(tgModIndexEnv);
        this.rbModIndexEnvStatic.setOnAction(e -> {
            this.sbModIndexEnvAmount.setDisable(true);
            this.modUseEnv = false;
            this.player.setModToUseCarrierEnv(false);
            this.player.updateParameter(DinkPlayer.Parameter.MODULATOR_INDEX_SWEEP, 0.0f);
            lblModIndexEnvValue.setText("");
        });
        this.rbModIndexEnvParallel = new RadioButton("Env");
        this.rbModIndexEnvParallel.setToggleGroup(tgModIndexEnv);
        this.rbModIndexEnvParallel.setOnAction(e -> {
            this.modUseEnv = true;
            this.sbModIndexEnvAmount.setDisable(true);
            this.player.setModToUseCarrierEnv(true);
            this.player.updateParameter(DinkPlayer.Parameter.MODULATOR_INDEX_SWEEP, 0.0f);
            lblModIndexEnvValue.setText("");
        });
        this.rbModIndexEnvRise = new RadioButton("Rise");
        this.rbModIndexEnvRise.setToggleGroup(tgModIndexEnv);
        this.rbModIndexEnvRise.setOnAction(e -> {
            this.modUseEnv = false;
            this.sbModIndexEnvAmount.setDisable(false);
            this.riseFallModIdxSweep = 1;
            this.player.setModToUseCarrierEnv(false);
            this.player.updateParameter(DinkPlayer.Parameter.MODULATOR_INDEX_SWEEP, this.modIdxSweep);
            lblModIndexEnvValue.setText(this.decimal3places.format(this.modIdxSweep * (float)this.riseFallModIdxSweep));
        });
        this.rbModIndexEnvFall = new RadioButton("Fall, ");
        this.rbModIndexEnvFall.setToggleGroup(tgModIndexEnv);
        this.rbModIndexEnvFall.setOnAction(e -> {
            this.modUseEnv = false;
            this.sbModIndexEnvAmount.setDisable(false);
            this.riseFallModIdxSweep = -1;
            this.player.setModToUseCarrierEnv(false);
            this.player.updateParameter(DinkPlayer.Parameter.MODULATOR_INDEX_SWEEP, this.modIdxSweep * -1.0f);
            lblModIndexEnvValue.setText(this.decimal3places.format(this.modIdxSweep * (float)this.riseFallModIdxSweep));
        });
        HBox hbModIndexEnv = new HBox();
        hbModIndexEnv.setSpacing(10.0);
        hbModIndexEnv.getChildren().addAll((Object[])new Node[]{lbModIndexEnv, this.rbModIndexEnvStatic, this.rbModIndexEnvParallel, this.rbModIndexEnvRise, this.rbModIndexEnvFall, this.sbModIndexEnvAmount, lblModIndexEnvValue});
        Label lbEnvOnset = new Label("Envelope Onset Duration: ");
        lbEnvOnset.setMinSize(100.0, 10.0);
        Label lblEnvOnsetValue = new Label("0");
        lblEnvOnsetValue.setMinSize(12.0, 10.0);
        lblEnvOnsetValue.setStyle("-fx-text-fill: brown;");
        Label lblEnvOnsetLow = new Label("0.001 Secs");
        lblEnvOnsetLow.setMinSize(30.0, 10.0);
        lblEnvOnsetLow.setStyle("-fx-text-fill: blue;");
        Label lblEnvOnsetHigh = new Label("0.250 Secs");
        lblEnvOnsetHigh.setMinSize(30.0, 10.0);
        lblEnvOnsetHigh.setStyle("-fx-text-fill: blue;");
        this.sbEnvOnset = new ScrollBar();
        this.sbEnvOnset.setOrientation(Orientation.HORIZONTAL);
        this.sbEnvOnset.setMax(250.0);
        this.sbEnvOnset.setMin(1.0);
        this.sbEnvOnset.valueProperty().addListener((observable, oldvalue, newvalue) -> {
            this.sbEnvOnsetValue = newvalue.intValue();
            float displayValue = (float)this.sbEnvOnsetValue / 1000.0f;
            this.player.updateParameter(DinkPlayer.Parameter.ENV_ATTACK_DURATION, displayValue);
            lblEnvOnsetValue.setText(this.decimal3places.format(displayValue));
        });
        HBox hbEnvOnset = new HBox();
        hbEnvOnset.setSpacing(6.0);
        hbEnvOnset.getChildren().addAll((Object[])new Node[]{lbEnvOnset, lblEnvOnsetLow, this.sbEnvOnset, lblEnvOnsetValue, lblEnvOnsetHigh});
        Label lbEnvSustain = new Label("Envelope Sustain Duration: ");
        lbEnvSustain.setMinSize(100.0, 10.0);
        Label lblEnvSustainValue = new Label("0");
        lblEnvSustainValue.setMinSize(12.0, 10.0);
        lblEnvSustainValue.setStyle("-fx-text-fill: brown;");
        Label lblEnvSustainLow = new Label("0.001 Secs");
        lblEnvSustainLow.setMinSize(30.0, 10.0);
        lblEnvSustainLow.setStyle("-fx-text-fill: blue;");
        Label lblEnvSustainHigh = new Label("0.250 Secs");
        lblEnvSustainHigh.setMinSize(30.0, 10.0);
        lblEnvSustainHigh.setStyle("-fx-text-fill: blue;");
        this.sbEnvSustain = new ScrollBar();
        this.sbEnvSustain.setOrientation(Orientation.HORIZONTAL);
        this.sbEnvSustain.setMin(1.0);
        this.sbEnvSustain.setMax(250.0);
        this.sbEnvSustain.valueProperty().addListener((observable, oldvalue, newvalue) -> {
            this.sbEnvSustainValue = newvalue.intValue();
            float valueNormal = (float)this.sbEnvSustainValue / 1000.0f;
            this.player.updateParameter(DinkPlayer.Parameter.ENV_SUSTAIN_DURATION, valueNormal);
            lblEnvSustainValue.setText(this.decimal3places.format(valueNormal));
        });
        HBox hbEnvSustain = new HBox();
        hbEnvSustain.setSpacing(6.0);
        hbEnvSustain.getChildren().addAll((Object[])new Node[]{lbEnvSustain, lblEnvSustainLow, this.sbEnvSustain, lblEnvSustainValue, lblEnvSustainHigh});
        Label lbEnvRelease = new Label("Envelope Release Duration: ");
        lbEnvRelease.setMinSize(100.0, 10.0);
        Label lblEnvReleaseValue = new Label("0");
        lblEnvReleaseValue.setMinSize(12.0, 10.0);
        lblEnvReleaseValue.setStyle("-fx-text-fill: brown;");
        Label lblEnvReleaseLow = new Label("0.001 Secs");
        lblEnvReleaseLow.setMinSize(30.0, 10.0);
        lblEnvReleaseLow.setStyle("-fx-text-fill: blue;");
        Label lblEnvReleaseHigh = new Label("0.250 Secs");
        lblEnvReleaseHigh.setMinSize(30.0, 10.0);
        lblEnvReleaseHigh.setStyle("-fx-text-fill: blue;");
        this.sbEnvRelease = new ScrollBar();
        this.sbEnvRelease.setOrientation(Orientation.HORIZONTAL);
        this.sbEnvRelease.setMin(1.0);
        this.sbEnvRelease.setMax(250.0);
        this.sbEnvRelease.valueProperty().addListener((observable, oldvalue, newvalue) -> {
            this.sbEnvReleaseValue = newvalue.intValue();
            float valueNormal = (float)this.sbEnvReleaseValue / 1000.0f;
            this.player.updateParameter(DinkPlayer.Parameter.ENV_RELEASE_DURATION, valueNormal);
            lblEnvReleaseValue.setText(this.decimal3places.format(valueNormal));
        });
        HBox hbEnvRelease = new HBox();
        hbEnvRelease.setSpacing(6.0);
        hbEnvRelease.getChildren().addAll((Object[])new Node[]{lbEnvRelease, lblEnvReleaseLow, this.sbEnvRelease, lblEnvReleaseValue, lblEnvReleaseHigh});
        Label lbAppVolume = new Label("Application Volume: ");
        lbAppVolume.setMinSize(100.0, 10.0);
        Label lblAppVolumeValue = new Label("0.0");
        lblAppVolumeValue.setMinSize(12.0, 10.0);
        lblAppVolumeValue.setStyle("-fx-text-fill: brown;");
        Label lblAppVolumeLow = new Label("Silent");
        lblAppVolumeLow.setMinSize(30.0, 10.0);
        lblAppVolumeLow.setStyle("-fx-text-fill: blue;");
        Label lblAppVolumeHigh = new Label("Full");
        lblAppVolumeHigh.setMinSize(30.0, 10.0);
        lblAppVolumeHigh.setStyle("-fx-text-fill: blue;");
        ScrollBar sbAppVolume = new ScrollBar();
        sbAppVolume.setOrientation(Orientation.HORIZONTAL);
        sbAppVolume.setMax(100.0);
        sbAppVolume.valueProperty().addListener((observable, oldvalue, newvalue) -> {
            double valueNormal = (double)newvalue.intValue() / 100.0;
            this.player.updateParameter(DinkPlayer.Parameter.VOLUME, (float)valueNormal);
            lblAppVolumeValue.setText(this.decimal2places.format(valueNormal));
        });
        HBox hbAppVolume = new HBox();
        hbAppVolume.setSpacing(6.0);
        hbAppVolume.getChildren().addAll((Object[])new Node[]{lbAppVolume, lblAppVolumeLow, sbAppVolume, lblAppVolumeValue, lblAppVolumeHigh});
        Button btnPlay = new Button("Play");
        btnPlay.setMinWidth(150.0);
        btnPlay.setOnAction(e -> this.player.play());
        Label lblPlay = new Label("or press <SpaceBar> to Play");
        HBox btnBox = new HBox();
        btnBox.setSpacing(10.0);
        btnBox.getChildren().addAll((Object[])new Node[]{btnPlay, lblPlay});
        HBox sectionBar0 = new HBox();
        sectionBar0.setMinHeight(3.0);
        sectionBar0.setStyle("-fx-background-color: #8080FF;");
        HBox sectionBar1 = new HBox();
        sectionBar1.setMinHeight(3.0);
        sectionBar1.setStyle("-fx-background-color: #8080FF;");
        HBox sectionBar2 = new HBox();
        sectionBar2.setMinHeight(3.0);
        sectionBar2.setStyle("-fx-background-color: #8080FF;");
        HBox sectionBar3 = new HBox();
        sectionBar3.setMinHeight(3.0);
        sectionBar3.setStyle("-fx-background-color: #8080FF;");
        root.setOnKeyPressed((EventHandler)this);
        scene.addEventFilter(KeyEvent.ANY, event -> this.handle((KeyEvent)event));
        GridPane grid = new GridPane();
        grid.setPadding(new Insets(10.0));
        grid.setVgap(10.0);
        grid.setHgap(10.0);
        int iRow = 0;
        HBox spacer = new HBox();
        spacer.setMinHeight(10.0);
        grid.addRow(iRow++, new Node[]{spacer});
        grid.addRow(iRow++, new Node[]{hbFileName});
        grid.addRow(iRow++, new Node[]{hbCarrierFrequency});
        grid.addRow(iRow++, new Node[]{hbCarrierPB});
        grid.addRow(iRow++, new Node[]{sectionBar0});
        grid.addRow(iRow++, new Node[]{hbLFOFrequency});
        grid.addRow(iRow++, new Node[]{hbLFOAmplitude});
        grid.addRow(iRow++, new Node[]{hbLFOFreqSweep});
        grid.addRow(iRow++, new Node[]{sectionBar1});
        grid.addRow(iRow++, new Node[]{hbModulatorPB});
        grid.addRow(iRow++, new Node[]{hbModIndexAmplitude});
        grid.addRow(iRow++, new Node[]{hbModIndexEnv});
        grid.addRow(iRow++, new Node[]{sectionBar2});
        grid.addRow(iRow++, new Node[]{hbEnvOnset});
        grid.addRow(iRow++, new Node[]{hbEnvSustain});
        grid.addRow(iRow++, new Node[]{hbEnvRelease});
        grid.addRow(iRow++, new Node[]{sectionBar3});
        grid.addRow(iRow++, new Node[]{hbAppVolume});
        grid.addRow(iRow, new Node[]{btnBox});
        root.getChildren().add((Object)grid);
        root.getChildren().add((Object)this.makeMenu());
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(e -> this.cleanClose());
        this.txtFileName.setText("dinkC6");
        this.sbCarrierFrequency.setValue(840.0);
        this.rbCarrierPBNone.setSelected(true);
        this.sbCarrierPBAmount.setDisable(true);
        this.rbLFOVibrato.setSelected(true);
        this.sbLFOFrequency.setValue(0.0);
        this.rbLFOFreqSweepNone.setSelected(true);
        this.rbModPMAbsolute.setSelected(true);
        this.sbModulatorFrequency.setValue(840.0);
        this.sbModIndexAmplitude.setValue(0.0);
        this.rbModIndexEnvStatic.setSelected(true);
        this.sbModIndexEnvAmount.setDisable(true);
        this.sbEnvOnset.setValue(4.0);
        this.sbEnvSustain.setValue(10.0);
        this.sbEnvRelease.setValue(200.0);
        sbAppVolume.setValue(100.0);
        btnPlay.requestFocus();
    }

    public void handle(KeyEvent event) {
        if (event.getCode() == KeyCode.SPACE || " ".equals(event.getCharacter())) {
            event.consume();
            if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                this.player.play();
            }
        }
    }

    private void sbModulatorFrequencyListener(double newvalue, Label lblModulatorFrequencyValue) {
        switch (this.synthMode) {
            case ABSOLUTE: {
                double midi = newvalue / 10.0;
                this.modulatorHzFactor = PitchFunctions.getHertzFromMidi(midi);
                this.player.updateParameter(DinkPlayer.Parameter.MODULATOR_FREQUENCY, (float)this.modulatorHzFactor);
                lblModulatorFrequencyValue.setText("Midi: " + this.decimal2places.format(midi) + ", Hz: " + this.decimal2places.format(this.modulatorHzFactor));
                break;
            }
            case RELATIVE: {
                double delta = newvalue - 600.0;
                this.modulatorHzFactor = Math.pow(2.0, delta / 200.0);
                this.player.updateParameter(DinkPlayer.Parameter.MODULATOR_FREQUENCY, (float)this.modulatorHzFactor);
                lblModulatorFrequencyValue.setText("Freq factor: " + this.decimal3places.format(this.modulatorHzFactor));
                break;
            }
        }
    }

    private MenuBar makeMenu() {
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = new Menu("_File");
        Menu helpMenu = new Menu("_Help");
        MenuItem loadMenuItem = new MenuItem("_Load");
        MenuItem saveMenuItem = new MenuItem("_Save");
        MenuItem exportMenuItem = new MenuItem("_Export");
        MenuItem exitMenuItem = new MenuItem("e_Xit");
        MenuItem helpMenuItem = new MenuItem("_Help");
        MenuItem aboutMenuItem = new MenuItem("_About");
        fileMenu.getItems().addAll((Object[])new MenuItem[]{loadMenuItem, saveMenuItem, new SeparatorMenuItem(), exportMenuItem, new SeparatorMenuItem(), exitMenuItem});
        helpMenu.getItems().addAll((Object[])new MenuItem[]{helpMenuItem, aboutMenuItem});
        menuBar.getMenus().addAll((Object[])new Menu[]{fileMenu, helpMenu});
        helpMenuItem.setOnAction(e -> new HelpBox().show());
        aboutMenuItem.setOnAction(e -> new AboutBox().show());
        loadMenuItem.setOnAction(e -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(this.defaultFileDirectory);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("XML files", "xml");
            chooser.setFileFilter(filter);
            if (chooser.showOpenDialog(null) != 0) {
                return;
            }
            if (!this.defaultFileDirectory.equals(chooser.getCurrentDirectory())) {
                this.defaultFileDirectory = chooser.getCurrentDirectory();
                this.propertiesChanged = true;
            }
            try {
                if (!chooser.getSelectedFile().exists()) {
                    throw new MalformedURLException("File does not exist.");
                }
                this.patchLoader(chooser.getSelectedFile().toURI().toURL());
                this.fileName = chooser.getSelectedFile().getName();
                System.out.println("DL2.makeMenu.loadMenuItem, fileName:" + this.fileName);
                int dotN = this.fileName.lastIndexOf(".");
                if (dotN > 0) {
                    this.fileName = this.fileName.substring(0, dotN);
                }
                System.out.println("DL2.makeMenu.loadMenuItem, fileName:" + this.fileName);
                this.txtFileName.setText(this.fileName);
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(null, "Oops! Something went wrong while loading: " + e1.getMessage(), "Error!", 0);
                return;
            }
            JOptionPane.showMessageDialog(null, "Settings loaded successfully!", "Success!", 1);
        });
        saveMenuItem.setOnAction(e -> {
            JFileChooser chooser = new JFileChooser(){
                private static final long serialVersionUID = 1L;

                @Override
                public void approveSelection() {
                    File f = this.getSelectedFile();
                    System.out.println("chooser selected file:" + f.getAbsolutePath());
                    if (f.exists()) {
                        int result = JOptionPane.showConfirmDialog(this, "Do you want to overwrite the existing file?", "File already exists", 1);
                        switch (result) {
                            case 0: {
                                super.approveSelection();
                                return;
                            }
                            case 1: {
                                return;
                            }
                            case -1: {
                                this.cancelSelection();
                                return;
                            }
                            case 2: {
                                this.cancelSelection();
                                return;
                            }
                        }
                    } else {
                        super.approveSelection();
                        return;
                    }
                }
            };
            System.out.println("setting default dir:" + this.defaultFileDirectory.getAbsolutePath());
            chooser.setCurrentDirectory(this.defaultFileDirectory);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("XML files", "xml");
            chooser.setFileFilter(filter);
            String defaultSaveFileName = String.valueOf(this.defaultFileDirectory.getAbsolutePath()) + "\\" + this.txtFileName.getText() + ".xml";
            chooser.setSelectedFile(new File(defaultSaveFileName));
            if (chooser.showSaveDialog(null) != 0) {
                return;
            }
            System.out.println("test match between chosen and default directories");
            if (!this.defaultFileDirectory.equals(chooser.getCurrentDirectory())) {
                this.defaultFileDirectory = chooser.getCurrentDirectory();
                this.propertiesChanged = true;
                System.out.println("changed default to:" + this.defaultFileDirectory.getAbsolutePath());
            }
            try {
                File file = chooser.getSelectedFile();
                if (!chooser.getFileFilter().accept(file)) {
                    System.out.println("Absolute Path: " + file.getAbsolutePath());
                    file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
                }
                this.settingsSaver(file);
            }
            catch (FileNotFoundException | XMLStreamException e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(null, "Oops! Something went wrong while saving. " + e1.getMessage(), "Error!", 0);
                return;
            }
            JOptionPane.showMessageDialog(null, "Settings saved successfully!", "Success!", 1);
        });
        exportMenuItem.setOnAction(e -> this.player.exportToFile((Window)this.primaryStage));
        exitMenuItem.setOnAction(e -> this.cleanClose());
        return menuBar;
    }

    private void settingsSaver(File file) throws FileNotFoundException, XMLStreamException {
        System.out.println("in settings saver");
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(new FileOutputStream(file));
        writer.writeStartDocument();
        writer.writeStartElement("dinkmaker");
        writer.writeStartElement("carrier");
        writer.writeStartElement("frequency");
        writer.writeCharacters(String.valueOf(this.carrierHz));
        writer.writeEndElement();
        writer.writeStartElement("sweep");
        if (this.rbCarrierPBNone.isSelected()) {
            writer.writeCharacters(String.valueOf(0));
        } else {
            writer.writeCharacters(String.valueOf(this.carrierPB * (float)this.riseFallCarrierPB));
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("lfo");
        writer.writeStartElement("mode");
        writer.writeCharacters(String.valueOf((Object)this.lfoSynthMode));
        writer.writeEndElement();
        writer.writeStartElement("frequency");
        writer.writeCharacters(String.valueOf(this.lfoFrequency));
        writer.writeEndElement();
        writer.writeStartElement("amplitude");
        writer.writeCharacters(String.valueOf(this.lfoAmplitude));
        writer.writeEndElement();
        writer.writeStartElement("sweep");
        if (this.rbLFOFreqSweepNone.isSelected()) {
            writer.writeCharacters(String.valueOf(0));
        } else {
            writer.writeCharacters(String.valueOf(this.lfoSweep * (float)this.riseFallLFOSweep));
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("modulator");
        writer.writeStartElement("synthMode");
        writer.writeCharacters(String.valueOf((Object)this.synthMode));
        writer.writeEndElement();
        writer.writeStartElement("frequency");
        writer.writeCharacters(String.valueOf(this.modulatorHzFactor));
        writer.writeEndElement();
        writer.writeStartElement("amplitude");
        writer.writeCharacters(String.valueOf(this.sbModulatorIndexValue));
        writer.writeEndElement();
        writer.writeStartElement("idxSweep");
        writer.writeCharacters(String.valueOf(this.modIdxSweep * (float)this.riseFallModIdxSweep));
        writer.writeEndElement();
        writer.writeStartElement("useEnv");
        writer.writeCharacters(String.valueOf(this.modUseEnv));
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("envelope");
        writer.writeStartElement("onset");
        writer.writeCharacters(String.valueOf(this.sbEnvOnsetValue));
        writer.writeEndElement();
        writer.writeStartElement("sustain");
        writer.writeCharacters(String.valueOf(this.sbEnvSustainValue));
        writer.writeEndElement();
        writer.writeStartElement("release");
        writer.writeCharacters(String.valueOf(this.sbEnvReleaseValue));
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
    }

    private void patchLoader(URL url) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document patchSettingsDoc = null;
        try {
            builder = factory.newDocumentBuilder();
            patchSettingsDoc = builder.parse(url.toURI().toString());
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        Element domRoot = patchSettingsDoc.getDocumentElement();
        System.out.println("DinkLauncher2.settingsLoader, defaultSettingsDoc, root node:" + domRoot.getNodeName());
        NodeList nodes = domRoot.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            if (nodes.item(i) instanceof Element) {
                Element node = (Element)nodes.item(i);
                NodeList subnodes = node.getChildNodes();
                int ii = 0;
                int nn = subnodes.getLength();
                while (ii < nn) {
                    if (subnodes.item(ii) instanceof Element) {
                        Element subnode = (Element)subnodes.item(ii);
                        this.loadSettings(node.getNodeName(), subnode.getNodeName(), subnode.getTextContent());
                    }
                    ++ii;
                }
            }
            ++i;
        }
    }

    private void loadSettings(String elementName, String subElementName, String elementText) {
        if (elementText == null) {
            System.out.println("DinkLauncher2.loadSettings, null contents for element " + elementName + "/" + subElementName);
            return;
        }
        block6 : switch (elementName) {
            case "carrier": {
                switch (subElementName) {
                    case "frequency": {
                        double hz = Double.valueOf(elementText);
                        double midi = PitchFunctions.getMidiFromHertz(hz);
                        this.sbCarrierFrequency.setValue((double)((int)(midi * 10.0)));
                        break;
                    }
                    case "sweep": {
                        double v = Double.valueOf(elementText);
                        if (v == 0.0) {
                            this.rbCarrierPBNone.fire();
                            break;
                        }
                        if (v < 0.0) {
                            this.sbCarrierPBAmount.setValue(100.0 * Math.abs(Double.valueOf(elementText)));
                            this.rbCarrierPBFall.fire();
                            break;
                        }
                        this.sbCarrierPBAmount.setValue(100.0 * Double.valueOf(elementText));
                        this.rbCarrierPBRise.fire();
                    }
                }
                break;
            }
            case "lfo": {
                switch (subElementName) {
                    case "mode": {
                        switch (elementText) {
                            case "LFO_VIBRATO": {
                                this.rbLFOVibrato.fire();
                                break;
                            }
                            case "LFO_TREMOLO": {
                                this.rbLFOTremolo.fire();
                            }
                        }
                        break;
                    }
                    case "frequency": {
                        double lfoFrequency = Double.valueOf(elementText);
                        double sqrt = Math.sqrt(lfoFrequency);
                        this.sbLFOFrequency.setValue((double)((int)(sqrt * 100.0) - 100));
                        break;
                    }
                    case "amplitude": {
                        this.sbLFOAmplitude.setValue(Double.valueOf(elementText) * 100.0);
                        break;
                    }
                    case "sweep": {
                        double val = Double.valueOf(elementText);
                        if (val == 0.0) {
                            this.rbLFOFreqSweepNone.fire();
                            break;
                        }
                        if (val < 0.0) {
                            this.sbLFOFreqSweepAmount.setValue(100.0 * Math.abs(val));
                            this.rbLFOFreqSweepFall.fire();
                            break;
                        }
                        this.sbLFOFreqSweepAmount.setValue(100.0 * val);
                        this.rbLFOFreqSweepRise.fire();
                    }
                }
                break;
            }
            case "modulator": {
                switch (subElementName) {
                    case "synthMode": {
                        switch (elementText) {
                            case "ABSOLUTE": {
                                this.rbModPMAbsolute.fire();
                                break;
                            }
                            case "RELATIVE": {
                                this.rbModPMRelative.fire();
                            }
                        }
                        break;
                    }
                    case "frequency": {
                        if (this.rbModPMAbsolute.isSelected()) {
                            double hz = Double.valueOf(elementText);
                            double midi = PitchFunctions.getMidiFromHertz(hz);
                            this.sbModulatorFrequency.setValue((double)((int)(midi * 10.0)));
                            break;
                        }
                        double factor = Double.valueOf(elementText);
                        double log = PitchFunctions.log2(factor);
                        this.sbModulatorFrequency.setValue(log * 200.0 + 600.0);
                        break;
                    }
                    case "amplitude": {
                        this.sbModIndexAmplitude.setValue(Double.valueOf(elementText) * 1000.0);
                        break;
                    }
                    case "idxSweep": {
                        double v = Double.valueOf(elementText);
                        if (v == 0.0) {
                            this.rbModIndexEnvStatic.fire();
                            break;
                        }
                        if (v < 0.0) {
                            this.sbModIndexEnvAmount.setValue(100.0 * Math.abs(v));
                            this.rbModIndexEnvFall.fire();
                            break;
                        }
                        this.sbModIndexEnvAmount.setValue(100.0 * v);
                        this.rbModIndexEnvRise.fire();
                        break;
                    }
                    case "useEnv": {
                        if (!Boolean.valueOf(elementText).booleanValue()) break;
                        this.rbModIndexEnvParallel.fire();
                    }
                }
                break;
            }
            case "envelope": {
                switch (subElementName) {
                    case "onset": {
                        this.sbEnvOnset.setValue((double)Integer.valueOf(elementText).intValue());
                        break block6;
                    }
                    case "sustain": {
                        this.sbEnvSustain.setValue((double)Integer.valueOf(elementText).intValue());
                        break block6;
                    }
                    case "release": {
                        this.sbEnvRelease.setValue((double)Integer.valueOf(elementText).intValue());
                    }
                }
            }
        }
    }

    private void cleanClose() {
        try {
            this.player.stop();
            if (this.propertiesChanged) {
                this.props.setProperty("dirLastUsed", this.defaultFileDirectory.getAbsolutePath());
                FileOutputStream out = new FileOutputStream(this.propsFile);
                this.props.store(out, "dinkmaker properties");
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        this.primaryStage.close();
    }
}

