/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.dinkmaker;

import com.adonax.pfaudio.core.CoreMixer;
import com.adonax.pfaudio.core.JavaWrapper;
import com.adonax.pfaudio.core.StereoPcmInputStream;
import com.adonax.pfaudio.events.PlayingNote;
import com.adonax.pfaudio.synthParts.EnvelopeDataSet;
import com.adonax.pfaudio.synthParts.EnvelopeRatesMaker;
import com.adonax.pfaudio.synthesizers.DinkSynth2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class DinkPlayer {
    private CoreMixer mixer = new CoreMixer();
    private JavaWrapper jw = new JavaWrapper(this.mixer);
    private DinkSynth2 synth = new DinkSynth2(3);
    private float playVolume;

    public DinkPlayer() {
        this.synth.setRunning(true);
        this.mixer.addTrack(this.synth);
        this.jw.start(null);
    }

    public void updateParameter(Parameter parameter, float valueNormal) {
        switch (parameter) {
            case CARRIER_FREQUENCY: {
                this.synth.setCarrierFrequency(valueNormal);
                break;
            }
            case CARRIER_PITCHBEND: {
                System.out.println("DPlayer2.updateParam.CarrierSweep");
                this.synth.setCarrierFreqSweepFactor(valueNormal);
                break;
            }
            case LFO_FREQUENCY: {
                this.synth.setLFOFrequency(valueNormal);
                break;
            }
            case LFO_AMPLITUDE: {
                this.synth.setLFOAmplitude(valueNormal);
                break;
            }
            case LFO_SWEEP: {
                this.synth.setLfoFreqSweepFactor(valueNormal);
                break;
            }
            case MODULATOR_FREQUENCY: {
                this.synth.setModulatorFrequency(valueNormal);
                break;
            }
            case MODULATOR_INDEX: {
                this.synth.setModulatorIndex(valueNormal);
                break;
            }
            case MODULATOR_INDEX_SWEEP: {
                this.synth.setModulatorIndexSweepFactor(valueNormal);
                break;
            }
            case ENV_ATTACK_DURATION: {
                this.setEnvelopeAttackDuration(valueNormal);
                break;
            }
            case ENV_SUSTAIN_DURATION: {
                this.setEnvelopeSustainDuration(valueNormal);
                break;
            }
            case ENV_RELEASE_DURATION: {
                this.setEnvelopeReleaseDuration(valueNormal);
                break;
            }
            case VOLUME: {
                this.setVolume(valueNormal);
            }
        }
    }

    public void setModToUseCarrierEnv(boolean bool) {
        this.synth.setModulatorUsesCarrierEnvelope(bool);
    }

    private void setEnvelopeAttackDuration(float seconds) {
        float[] dur = new float[]{seconds};
        float[] levels = new float[]{1.0f};
        float[] rates = EnvelopeRatesMaker.makeDeltasArray(0.0f, levels, 44100, dur);
        EnvelopeDataSet eds = this.synth.getEnvelopeDataSet();
        float[][] env = eds.getCarrierEnvelope(0);
        env[0][0] = rates[0];
        env = eds.getModulatorEnvelope(0);
        env[0][0] = rates[0];
    }

    private void setEnvelopeSustainDuration(float seconds) {
        float[] dur = new float[]{seconds};
        float[] levels = new float[]{0.99f};
        float[] rates = EnvelopeRatesMaker.makeDeltasArray(1.0f, levels, 44100, dur);
        EnvelopeDataSet eds = this.synth.getEnvelopeDataSet();
        float[][] env = eds.getCarrierEnvelope(0);
        env[0][1] = rates[0];
        env = eds.getModulatorEnvelope(0);
        env[0][1] = rates[0];
    }

    private void setEnvelopeReleaseDuration(float seconds) {
        float[] dur = new float[]{seconds};
        float[] level = new float[]{0.0f};
        float[] rates = EnvelopeRatesMaker.makeDeltasArray(1.0f, level, 44100, dur);
        EnvelopeDataSet eds = this.synth.getEnvelopeDataSet();
        float[][] env = eds.getCarrierEnvelope(0);
        env[0][2] = rates[0];
        env = eds.getModulatorEnvelope(0);
        env[0][2] = rates[0];
    }

    private void setVolume(float valueNormal) {
        this.playVolume = valueNormal;
    }

    public void setSynthMode(SynthMode synthMode) {
        switch (synthMode) {
            case LFO_TREMOLO: {
                this.synth.setLFOTarget(DinkSynth2.LFOTarget.TREMOLO);
                break;
            }
            case LFO_VIBRATO: {
                this.synth.setLFOTarget(DinkSynth2.LFOTarget.VIBRATO);
                break;
            }
            case ABSOLUTE: {
                this.synth.setModulatorPitchMode(DinkSynth2.ModulatorPitchMode.ABSOLUTE);
                break;
            }
            case RELATIVE: {
                this.synth.setModulatorPitchMode(DinkSynth2.ModulatorPitchMode.RELATIVE);
            }
        }
    }

    public void play() {
        this.synth.play(1.0f, this.playVolume, 0.0f);
    }

    public void stop() {
        this.jw.stop();
    }

    public void exportToFile(Window window) {
        this.stop();
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save to Wav File");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Wav Files", new String[]{"*.wav"}));
        File file = fileChooser.showSaveDialog(window);
        if (file != null) {
            float[] pcmData = null;
            try {
                pcmData = this.getPCMData(this.synth);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.jw.start(null);
                return;
            }
            StereoPcmInputStream spcmIS = new StereoPcmInputStream();
            spcmIS.setDataFrames(pcmData);
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
            AudioInputStream ais = new AudioInputStream(spcmIS, audioFormat, pcmData.length / 2);
            AudioFileFormat.Type fileType = AudioFileFormat.Type.WAVE;
            try {
                AudioSystem.write(ais, fileType, file);
                ais.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            System.out.println("Export completed, mixer restarted.");
        } else {
            System.out.println("Export cancelled");
        }
        this.jw.start(null);
    }

    private float[] getPCMData(DinkSynth2 synth) throws IOException {
        ArrayList<Float> pcmFrames = new ArrayList<Float>();
        PlayingNote note = synth.play(1.0f, this.playVolume, 0.0f);
        while (note.isPlaying()) {
            float[] frame = synth.read();
            pcmFrames.add(Float.valueOf(frame[0]));
            pcmFrames.add(Float.valueOf(frame[1]));
        }
        float[] pcmData = new float[pcmFrames.size()];
        int i = 0;
        int n = pcmFrames.size();
        while (i < n) {
            pcmData[i] = ((Float)pcmFrames.get(i)).floatValue();
            ++i;
        }
        return pcmData;
    }

    public static enum Parameter {
        CARRIER_FREQUENCY,
        CARRIER_PITCHBEND,
        LFO_FREQUENCY,
        LFO_AMPLITUDE,
        LFO_SWEEP,
        MODULATOR_FREQUENCY,
        MODULATOR_PITCHBEND,
        MODULATOR_INDEX,
        MODULATOR_INDEX_SWEEP,
        ENV_ATTACK_DURATION,
        ENV_SUSTAIN_DURATION,
        ENV_RELEASE_DURATION,
        VOLUME;

    }

    public static enum SynthMode {
        LFO_TREMOLO,
        LFO_VIBRATO,
        ABSOLUTE,
        RELATIVE;

    }
}

