/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.core;

import com.adonax.pfaudio.core.PFMixerTrack;
import com.adonax.pfaudio.events.EventScheduler;
import java.util.concurrent.CopyOnWriteArrayList;

public class CoreMixer {
    public static volatile long currentFrame;
    public static volatile long nextEventFrame;
    public static final EventScheduler eventScheduler;
    private PFMixerTrack[] trackCache;
    private PFMixerTrack[] mixerTracks;
    private CopyOnWriteArrayList<PFMixerTrack> trackManager;
    private volatile boolean trackCacheUpdated;
    private int trackLength;
    private float[] audioData = new float[2];
    private volatile boolean playing;

    static {
        eventScheduler = new EventScheduler();
    }

    public int getTrackLength() {
        return this.trackLength;
    }

    public CoreMixer() {
        currentFrame = 0L;
        nextEventFrame = Long.MAX_VALUE;
        this.trackManager = new CopyOnWriteArrayList();
    }

    public void addTrack(PFMixerTrack track) {
        this.trackManager.add(track);
    }

    public void removeTrack(PFMixerTrack track) throws IllegalThreadStateException {
        this.trackManager.remove(track);
    }

    public void updateTracks() {
        int size = this.trackManager.size();
        PFMixerTrack[] workCopyTracks = new PFMixerTrack[size];
        int i = 0;
        while (i < size) {
            workCopyTracks[i] = this.trackManager.get(i);
            ++i;
        }
        this.trackCache = workCopyTracks;
        this.trackCacheUpdated = true;
        System.out.println("CoreMixer.updateTracks, new size:" + size);
    }

    public void prepareToGo() throws IllegalStateException {
        if (this.playing) {
            throw new IllegalStateException("PFCoreMixer already running!");
        }
        nextEventFrame = eventScheduler.peek();
        this.updateTracks();
        this.playing = true;
    }

    public void setToStop() throws IllegalStateException {
        if (!this.playing) {
            throw new IllegalStateException("PFCoreMixer already stopped!");
        }
        this.playing = false;
    }

    public void getFrame(float[] normalizedOut) {
        if (this.trackCacheUpdated) {
            this.trackCacheUpdated = false;
            this.mixerTracks = this.trackCache;
            this.trackLength = this.mixerTracks.length;
        }
        ++currentFrame;
        while (nextEventFrame < currentFrame) {
            eventScheduler.execute(currentFrame);
            nextEventFrame = eventScheduler.peek();
        }
        int i = 0;
        while (i < this.trackLength) {
            if (this.mixerTracks[i].isRunning()) {
                try {
                    this.audioData = this.mixerTracks[i].read();
                    normalizedOut[0] = normalizedOut[0] + this.audioData[0];
                    normalizedOut[1] = normalizedOut[1] + this.audioData[1];
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }
}

