/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.core;

import com.adonax.pfaudio.core.CoreMixer;
import java.io.IOException;
import java.io.InputStream;

public class CoreMixerInputStream
extends InputStream {
    private CoreMixer mixer;
    private float[] normalizedOut = new float[2];
    private int[] frameBytes = new int[4];
    private int idx;
    private int cursor;
    int framesToRead;

    public void setFramesToRead(int framesToRead) {
        this.framesToRead = framesToRead;
    }

    public void setCoreMixer(CoreMixer coreMixer) {
        this.mixer = coreMixer;
    }

    @Override
    public int read() throws IOException {
        if (this.available() > 0) {
            this.idx &= 3;
            if (this.idx == 0) {
                ++this.cursor;
                this.normalizedOut[0] = 0.0f;
                this.normalizedOut[1] = 0.0f;
                this.mixer.getFrame(this.normalizedOut);
                this.normalizedOut[0] = this.normalizedOut[0] * 32767.0f;
                this.normalizedOut[1] = this.normalizedOut[1] * 32767.0f;
                this.frameBytes[0] = (char)this.normalizedOut[0];
                this.frameBytes[1] = (char)((int)this.normalizedOut[0] >> 8);
                this.frameBytes[2] = (char)this.normalizedOut[1];
                this.frameBytes[3] = (char)((int)this.normalizedOut[1] >> 8);
            }
            return this.frameBytes[this.idx++];
        }
        return -1;
    }

    @Override
    public int available() {
        return 4 * (this.framesToRead - 1 - this.cursor) + (4 - this.idx % 4);
    }

    @Override
    public void close() {
        System.out.println("CoreMixerInputStream stopped after reading frames:" + this.cursor);
    }
}

