/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.core;

import com.adonax.pfaudio.core.CoreMixer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class JavaWrapper {
    private Mixer mixer;
    private CoreMixer coreMix;
    public final AudioFormat audioFmt = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
    public final int FRAME_SIZE = 4;
    private volatile boolean playing;
    private final int outBufferSize;
    private byte[] outBuffer;
    int err = 0;

    public void setMixer(Mixer mixer) {
        this.mixer = mixer;
    }

    public JavaWrapper(CoreMixer cm) {
        this(cm, 8192);
    }

    public JavaWrapper(CoreMixer cm, int outBufferSize) {
        this.outBufferSize = outBufferSize;
        this.outBuffer = new byte[outBufferSize];
        this.coreMix = cm;
    }

    public void start(Mixer mixer) throws IllegalStateException {
        if (this.playing) {
            throw new IllegalStateException("Already running.");
        }
        this.coreMix.prepareToGo();
        this.playing = true;
        this.mixer = mixer;
        FrameMixerPlayer mixerPlayer = new FrameMixerPlayer();
        Thread t = new Thread(mixerPlayer);
        t.setPriority(10);
        t.start();
    }

    public void stop() throws IllegalStateException {
        if (!this.playing) {
            throw new IllegalStateException("Already stopped.");
        }
        this.playing = false;
        System.out.println("JavaWrapper.stop, playing to false");
        this.coreMix.setToStop();
    }

    private class FrameMixerPlayer
    implements Runnable {
        private FrameMixerPlayer() {
        }

        @Override
        public void run() {
            Line sdl = null;
            try {
                try {
                    float[] normalizedOut = new float[2];
                    JavaWrapper.this.outBuffer = new byte[JavaWrapper.this.outBufferSize];
                    sdl = this.makeOutputLine();
                    sdl.open(JavaWrapper.this.audioFmt, JavaWrapper.this.outBufferSize);
                    sdl.start();
                    while (JavaWrapper.this.playing) {
                        int i = 0;
                        while (i < JavaWrapper.this.outBufferSize) {
                            normalizedOut[0] = 0.0f;
                            normalizedOut[1] = 0.0f;
                            JavaWrapper.this.coreMix.getFrame(normalizedOut);
                            normalizedOut[0] = normalizedOut[0] * 32767.0f;
                            normalizedOut[1] = normalizedOut[1] * 32767.0f;
                            ((JavaWrapper)JavaWrapper.this).outBuffer[i++] = (byte)normalizedOut[0];
                            ((JavaWrapper)JavaWrapper.this).outBuffer[i++] = (byte)((int)normalizedOut[0] >> 8);
                            ((JavaWrapper)JavaWrapper.this).outBuffer[i++] = (byte)normalizedOut[1];
                            ((JavaWrapper)JavaWrapper.this).outBuffer[i++] = (byte)((int)normalizedOut[1] >> 8);
                        }
                        sdl.write(JavaWrapper.this.outBuffer, 0, JavaWrapper.this.outBufferSize);
                    }
                    System.out.println("JWrapper, playing now false, exiting while");
                }
                catch (LineUnavailableException e) {
                    System.out.println("LineUnavailableException");
                    e.printStackTrace();
                    sdl.close();
                    sdl = null;
                }
            }
            finally {
                sdl.close();
                sdl = null;
            }
        }

        private SourceDataLine makeOutputLine() throws LineUnavailableException {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, JavaWrapper.this.audioFmt);
            SourceDataLine sdl = JavaWrapper.this.mixer == null ? (SourceDataLine)AudioSystem.getLine(info) : (SourceDataLine)JavaWrapper.this.mixer.getLine(info);
            return sdl;
        }
    }
}

