/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.core;

import java.io.IOException;
import java.io.InputStream;

public class StereoPcmInputStream
extends InputStream {
    private float[] dataFrames;
    private int framesCounter;
    private int cursor;
    private int[] pcmOut = new int[2];
    private int[] frameBytes = new int[4];
    private int idx;
    private int framesToRead;

    public void setDataFrames(float[] dataFrames) {
        this.dataFrames = dataFrames;
        this.framesToRead = dataFrames.length / 2;
    }

    @Override
    public int read() throws IOException {
        if (this.available() > 0) {
            this.idx &= 3;
            if (this.idx == 0) {
                ++this.framesCounter;
                this.pcmOut[0] = (int)(this.dataFrames[this.cursor++] * 32767.0f);
                this.pcmOut[1] = (int)(this.dataFrames[this.cursor++] * 32767.0f);
                this.frameBytes[0] = (char)this.pcmOut[0];
                this.frameBytes[1] = (char)(this.pcmOut[0] >> 8);
                this.frameBytes[2] = (char)this.pcmOut[1];
                this.frameBytes[3] = (char)(this.pcmOut[1] >> 8);
            }
            return this.frameBytes[this.idx++];
        }
        return -1;
    }

    @Override
    public int available() {
        return 4 * (this.framesToRead - 1 - this.framesCounter) + (4 - this.idx % 4);
    }

    @Override
    public void reset() {
        this.cursor = 0;
        this.framesCounter = 0;
        this.idx = 0;
    }

    @Override
    public void close() {
        System.out.println("StereoPcmInputStream stopped after reading frames:" + this.framesCounter);
    }
}

