/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.events;

import com.adonax.pfaudio.core.CoreMixer;
import com.adonax.pfaudio.events.AdvanceCommand;
import com.adonax.pfaudio.events.Advanceable;
import com.adonax.pfaudio.events.AudioCommand;
import com.adonax.pfaudio.events.AudioEvent;
import com.adonax.pfaudio.events.PlayCommand;
import com.adonax.pfaudio.events.Playable;
import java.util.concurrent.ConcurrentSkipListSet;

public class EventScheduler {
    public long startSyncNanoTime;
    public long startSyncFrame;
    public final double FRAMES_PER_NANO;
    protected ConcurrentSkipListSet<AudioEvent> schedule = new ConcurrentSkipListSet();

    public EventScheduler() {
        this.FRAMES_PER_NANO = 4.41E-5;
    }

    public void clearAll() {
        this.schedule.clear();
    }

    public void clearObject(Object obj) {
        for (AudioEvent av : this.schedule) {
            if (av.audioCommand instanceof AdvanceCommand) {
                AdvanceCommand b = (AdvanceCommand)av.audioCommand;
                Advanceable c = b.advanceable;
                if (c != obj) continue;
                this.schedule.remove(av);
                continue;
            }
            if (!(av.audioCommand instanceof PlayCommand)) continue;
            PlayCommand pc = (PlayCommand)av.audioCommand;
            Playable pb = pc.playable;
            if (pb == obj) {
                this.schedule.remove(av);
                continue;
            }
            if (pc.lazyNote == null || pc.lazyNote != obj) continue;
            this.schedule.remove(av);
        }
    }

    public void schedule(AudioEvent[] events, long startFrame) {
        if (startFrame == 0L) {
            startFrame = CoreMixer.currentFrame;
        }
        int i = 0;
        int n = events.length;
        while (i < n) {
            this.schedule.add(new AudioEvent(events[i].audioCommand, events[i].frame + startFrame));
            ++i;
        }
        CoreMixer.nextEventFrame = this.peek();
    }

    public void setSync(long explicitFrame) {
        this.startSyncFrame = explicitFrame;
        this.startSyncNanoTime = System.nanoTime();
    }

    public void scheduleAtSyncTime(AudioCommand audioCommand, long nanoTime) {
        long elapsedTime = nanoTime - this.startSyncNanoTime;
        double elapsedFrames = (double)elapsedTime * this.FRAMES_PER_NANO;
        this.schedule.add(new AudioEvent(audioCommand, this.startSyncFrame + (long)elapsedFrames + 1800L));
        CoreMixer.nextEventFrame = this.peek();
    }

    public long peek() {
        if (this.schedule.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return this.schedule.first().frame;
    }

    public void execute(long currentFrame) {
        this.schedule.pollFirst().audioCommand.run(currentFrame);
    }

    public void dump() {
        for (AudioEvent ae : this.schedule) {
            System.out.println("EventScheduler.dump, frame:" + ae.frame + "  command:" + ae.audioCommand);
        }
    }
}

