/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.events;

import com.adonax.pfaudio.events.AudioCommand;
import com.adonax.pfaudio.events.LazyNote;
import com.adonax.pfaudio.events.NoteListener;
import com.adonax.pfaudio.events.Playable;
import com.adonax.pfaudio.events.PlayingNote;
import com.adonax.pfaudio.events.ReleaseCommand;

public class PlayCommand
implements AudioCommand {
    public final Playable playable;
    private final float[] pitch;
    private final float volume;
    private final float pan;
    private final NoteListener[] listeners;
    public final LazyNote lazyNote;
    private final ReleaseCommand releaseCommand;

    public Playable getPlayable() {
        return this.playable;
    }

    public PlayingNote getReleasable() {
        return this.releaseCommand.getPlayingNote();
    }

    public PlayCommand(Playable playable, float pitch, float volume, float pan, NoteListener[] listeners) {
        this(playable, pitch, volume, pan, new ReleaseCommand(null), listeners, null);
    }

    public PlayCommand(LazyNote lazyNote, NoteListener[] listeners) {
        this(null, 1.0f, 0.0f, 0.0f, new ReleaseCommand(null), listeners, lazyNote);
    }

    public PlayCommand(LazyNote lazyNote, ReleaseCommand rc, NoteListener[] listeners) {
        this(null, 1.0f, 0.0f, 0.0f, rc, listeners, lazyNote);
    }

    public PlayCommand(Playable playable, float pitch, float volume, float pan, ReleaseCommand releaseCommand, NoteListener[] listeners) {
        this(playable, pitch, volume, pan, releaseCommand, listeners, null);
    }

    public PlayCommand(Playable playable, float pitch, float volume, float pan, ReleaseCommand releaseCommand, NoteListener[] listeners, LazyNote lazyNote) {
        this.lazyNote = lazyNote;
        this.playable = playable;
        this.pitch = new float[1];
        this.pitch[0] = pitch;
        this.volume = volume;
        this.pan = pan;
        this.releaseCommand = releaseCommand;
        if (listeners == null) {
            listeners = new NoteListener[]{};
        }
        this.listeners = listeners;
    }

    public PlayCommand(Playable playable, float[] frequency, float volume, float pan, ReleaseCommand releaseCommand, NoteListener[] listeners, LazyNote lazyNote) {
        this.lazyNote = lazyNote;
        this.playable = playable;
        this.pitch = frequency;
        this.volume = volume;
        this.pan = pan;
        this.releaseCommand = releaseCommand;
        if (listeners == null) {
            listeners = new NoteListener[]{};
        }
        this.listeners = listeners;
    }

    @Override
    public void run(long currentFrame) {
        if (this.lazyNote != null) {
            this.releaseCommand.setPlayingNote(this.lazyNote.getPlayable().play(this.lazyNote.getFrequency(), this.lazyNote.getVolume(), this.lazyNote.getPan(), this.listeners));
        } else {
            this.releaseCommand.setPlayingNote(this.playable.play(this.pitch, this.volume, this.pan, this.listeners));
        }
    }

    public String toString() {
        String s = this.getClass() + "\n playable:" + this.playable + "\n releaseCommand:" + this.releaseCommand + "\n pitch:" + this.pitch + ", vol:" + this.volume + ", pan:" + this.pan + "\n NoteListener:" + this.listeners + "\n LazyNote:" + this.lazyNote;
        return s;
    }
}

