/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.midi;

public class PitchFunctions {
    public static final int A_MIDI = 69;
    public static final float HALF_STEP = (float)Math.pow(2.0, -12.0);
    public static boolean[] whiteKeys = new boolean[12];

    public static double getHertzFromMidi(double midiVal) {
        return 440.0 * Math.pow(2.0, (midiVal - 69.0) / 12.0);
    }

    public static double getCentsFactor(int cents) {
        return Math.pow(2.0, (double)cents / 1200.0);
    }

    public static double getCentsDifference(double freqA, double freqB) {
        return 1200.0 * Math.log(freqB / freqA) / Math.log(2.0);
    }

    public static double getCentsFromMidiInterval(double midiInterval) {
        double freqA = PitchFunctions.getHertzFromMidi(30.0);
        double freqB = PitchFunctions.getHertzFromMidi(30.0 + midiInterval);
        return PitchFunctions.getCentsDifference(freqA, freqB);
    }

    public static double getHertzFactorFromMidiInterval(double midiInterval) {
        double px = PitchFunctions.getHertzFromMidi(20.0);
        double qy = PitchFunctions.getHertzFromMidi(20.0 + midiInterval);
        return qy / px;
    }

    public static boolean isWhiteKey(int midiKey) {
        if (!whiteKeys[0]) {
            PitchFunctions.whiteKeys[0] = true;
            PitchFunctions.whiteKeys[1] = false;
            PitchFunctions.whiteKeys[2] = true;
            PitchFunctions.whiteKeys[3] = false;
            PitchFunctions.whiteKeys[4] = true;
            PitchFunctions.whiteKeys[5] = true;
            PitchFunctions.whiteKeys[6] = false;
            PitchFunctions.whiteKeys[7] = true;
            PitchFunctions.whiteKeys[8] = false;
            PitchFunctions.whiteKeys[9] = true;
            PitchFunctions.whiteKeys[10] = false;
            PitchFunctions.whiteKeys[11] = true;
        }
        return whiteKeys[midiKey % 12];
    }

    public static double log2(double n) {
        return Math.log(n) / Math.log(2.0);
    }

    public static double getMidiFromHertz(double hz) {
        return 12.0 * PitchFunctions.log2(hz / 440.0) + 69.0;
    }
}

