/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.synthParts;

import com.adonax.pfaudio.synthParts.EnvCursor;

public class Envelope {
    private final float[] deltas;
    private final float[] levels;
    private final float[] rateScalings;
    private final int lastStage;

    public Envelope(float[] deltas, float[] levels, float[] rateScalings) {
        this.lastStage = levels.length - 1;
        this.deltas = deltas;
        this.levels = levels;
        this.rateScalings = rateScalings;
    }

    public Envelope(float[][] envelopSet) {
        this(envelopSet[0], envelopSet[1], envelopSet[2]);
    }

    public void initializeCursor(EnvCursor ec, float hertz) {
        ec.stage = 0;
        ec.delta = this.deltas[0] * (1.0f + this.rateScalings[ec.stage] * hertz);
        ec.steps = (int)(((double)this.levels[0] - ec.value) / ec.delta);
        if (ec.steps < 0) {
            ec.steps = 0;
        }
        ec.done = false;
    }

    public void tick(EnvCursor ec, float freq) {
        if (ec.steps > 0) {
            ec.value += ec.delta;
            --ec.steps;
        } else if (ec.stage == this.lastStage) {
            if (!ec.done) {
                ec.value = this.levels[this.lastStage];
                ec.done = true;
            }
        } else {
            ++ec.stage;
            ec.delta = this.deltas[ec.stage] * (1.0f + this.rateScalings[ec.stage] * freq);
            ec.steps = (int)(((double)this.levels[ec.stage] - ec.value) / ec.delta);
        }
    }

    public String dump() {
        StringBuilder strb = new StringBuilder();
        strb.append("Envelope.deltas:");
        int i = 0;
        int n = this.deltas.length;
        while (i < n) {
            strb.append(String.valueOf(this.deltas[i]) + " ");
            ++i;
        }
        strb.append("\nEnvelope.levels:");
        i = 0;
        n = this.levels.length;
        while (i < n) {
            strb.append(String.valueOf(this.levels[i]) + " ");
            ++i;
        }
        strb.append("\nEnvelope.rateScalings:");
        i = 0;
        n = this.rateScalings.length;
        while (i < n) {
            strb.append(String.valueOf(this.rateScalings[i]) + " ");
            ++i;
        }
        strb.append("\nEnvelope.lastStage:" + this.lastStage);
        return strb.toString();
    }
}

