/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.synthParts;

import com.adonax.pfaudio.synthParts.FMOp;
import com.adonax.pfaudio.synthParts.SineTable;

public class OpFB
implements FMOp {
    float cursor;
    float pitchIncr;
    final int tblSize = SineTable.getOperationalSize();
    private float feedback;
    private final float feedbackAmplitude;

    public OpFB(float feedbackAmplitude) {
        this.feedbackAmplitude = feedbackAmplitude;
    }

    @Override
    public void setFrequency(float freq) {
        this.pitchIncr = freq * (float)this.tblSize / 44100.0f;
    }

    @Override
    public void setFrequency(float freq, float phase) {
        this.pitchIncr = freq * (float)this.tblSize / 44100.0f;
        this.cursor = phase * (float)this.tblSize;
    }

    @Override
    public float get() {
        this.cursor += this.pitchIncr;
        while (this.cursor >= (float)this.tblSize) {
            this.cursor -= (float)this.tblSize;
        }
        this.feedback = SineTable.get(this.cursor);
        this.feedback = this.cursor + this.feedback * this.feedbackAmplitude;
        while (this.feedback >= (float)this.tblSize) {
            this.feedback -= (float)this.tblSize;
        }
        return SineTable.get(this.feedback);
    }

    @Override
    public float get(float modulationAmt) {
        return 0.0f;
    }
}

