/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.synthParts;

import com.adonax.pfaudio.synthParts.FMOp;
import com.adonax.pfaudio.synthParts.SineTable;

public class OpN
implements FMOp {
    float cursor;
    float pitchIncr;
    final int tblSize = SineTable.getOperationalSize();

    public OpN() {
    }

    public OpN(float freq) {
        this();
        this.setFrequency(freq);
    }

    public OpN(float freq, float startingPhase) {
        this();
        this.setFrequency(freq);
        this.cursor = startingPhase * (float)this.tblSize;
    }

    @Override
    public void setFrequency(float freq) {
        this.pitchIncr = freq * (float)this.tblSize / 44100.0f;
    }

    @Override
    public void setFrequency(float freq, float phase) {
        this.pitchIncr = freq * (float)this.tblSize / 44100.0f;
        this.cursor = phase * (float)this.tblSize;
    }

    @Override
    public float get() {
        this.cursor += this.pitchIncr;
        while (this.cursor >= (float)this.tblSize) {
            this.cursor -= (float)this.tblSize;
        }
        return SineTable.get(this.cursor);
    }

    @Override
    public float get(float modulationAmt) {
        return 0.0f;
    }
}

