/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.synthParts;

import com.adonax.pfaudio.synthParts.FMOp;
import com.adonax.pfaudio.synthParts.SineTable;

public class OpPML
implements FMOp {
    float cursor;
    float temp;
    float pitchIncr;
    final int tblSize = SineTable.getOperationalSize();

    @Override
    public void setFrequency(float freq) {
        this.pitchIncr = freq * (float)this.tblSize / 44100.0f;
    }

    @Override
    public void setFrequency(float freq, float phase) {
        this.pitchIncr = freq * (float)this.tblSize / 44100.0f;
        this.cursor = phase * (float)this.tblSize;
    }

    @Override
    public float get() {
        return this.get(0.0f);
    }

    @Override
    public float get(float modulationAmt) {
        this.cursor += this.pitchIncr;
        while (this.cursor >= (float)this.tblSize) {
            this.cursor -= (float)this.tblSize;
        }
        this.temp = this.cursor + modulationAmt;
        while (this.temp < 0.0f) {
            this.temp += (float)this.tblSize;
        }
        while (this.temp >= (float)this.tblSize) {
            this.temp -= (float)this.tblSize;
        }
        return SineTable.get(this.temp);
    }
}

