/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.synthParts;

import com.adonax.pfaudio.synthParts.FMOp;
import com.adonax.pfaudio.synthParts.WaveTableMaker;

public class OpSqN
implements FMOp {
    float cursor;
    float pitchIncr;
    final int tblSize;
    private float[] squareTbl = WaveTableMaker.makeGeneratedSquareWT(1);

    public OpSqN() {
        this.tblSize = this.squareTbl.length;
    }

    public OpSqN(float freq) {
        this();
        this.setFrequency(freq);
    }

    public OpSqN(float freq, float startingPhase) {
        this();
        this.setFrequency(freq);
        this.cursor = startingPhase * (float)this.tblSize;
    }

    @Override
    public void setFrequency(float freq) {
        this.pitchIncr = freq * (float)this.tblSize / 44100.0f;
    }

    @Override
    public void setFrequency(float freq, float phase) {
        this.pitchIncr = freq * (float)this.tblSize / 44100.0f;
        this.cursor = phase * (float)this.tblSize;
    }

    public void setHarmonicsInWaveTable(int harmonics) {
        this.squareTbl = WaveTableMaker.makeGeneratedSquareWT(harmonics);
    }

    @Override
    public float get() {
        this.cursor += this.pitchIncr;
        while (this.cursor >= (float)this.tblSize) {
            this.cursor -= (float)this.tblSize;
        }
        return this.squareTbl[(int)this.cursor];
    }

    @Override
    public float get(float modulationAmt) {
        return 0.0f;
    }
}

