/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.synthParts;

import com.adonax.pfaudio.events.NoteListener;
import com.adonax.pfaudio.events.PlayableNoteEvent;
import com.adonax.pfaudio.events.PlayingNote;
import com.adonax.pfaudio.synthParts.EnvCursor;
import com.adonax.pfaudio.synthParts.Envelope;
import com.adonax.pfaudio.synthParts.EnvelopeDataSet;
import com.adonax.pfaudio.synthParts.Synth;
import com.adonax.pfaudio.synthParts.VolumeMap;
import com.adonax.pfaudio.synthParts.VolumeMapMaker;
import java.io.IOException;

public abstract class PolySynth
implements Synth {
    protected String synthName = "CoreSynth";
    protected volatile boolean running;
    protected final VolumeMap vmVolume = new VolumeMap(VolumeMapMaker.makeX2VolumeMap());
    protected final VolumeMap vmCarrier = new VolumeMap(VolumeMapMaker.makeX6VolumeMap());
    protected final VolumeMap vmModulator = new VolumeMap(VolumeMapMaker.makeReverseCosVolumeMap());
    protected volatile float synthMasterVolume;
    protected volatile float targetVolume;
    protected volatile float volIncr;
    protected volatile int volTargetSteps;
    protected float MAX_VOLUME = 0.8f;
    protected PolySynthNote[] notes;
    protected EnvelopeDataSet edsUse;
    protected float[] synthBuffer = new float[2];

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public void setVolume(float normalized) {
        this.targetVolume = this.MAX_VOLUME * this.vmVolume.get(normalized);
        this.volIncr = (this.targetVolume - this.synthMasterVolume) / 1024.0f;
        this.volTargetSteps = 1024;
    }

    public EnvelopeDataSet getEnvelopeDataSet() {
        return this.edsUse;
    }

    public void setEnvelopeDataSet(EnvelopeDataSet eds) {
        this.edsUse = eds;
    }

    @Override
    public float[] read() throws IOException {
        this.synthBuffer[0] = 0.0f;
        this.synthBuffer[1] = 0.0f;
        PolySynthNote[] polySynthNoteArray = this.notes;
        int n = this.notes.length;
        int n2 = 0;
        while (n2 < n) {
            PolySynthNote note = polySynthNoteArray[n2];
            note.read(this.synthBuffer);
            ++n2;
        }
        if (this.volTargetSteps > 0) {
            --this.volTargetSteps;
            this.synthMasterVolume += this.volIncr;
        }
        this.synthBuffer[0] = this.synthBuffer[0] * this.synthMasterVolume;
        this.synthBuffer[1] = this.synthBuffer[1] * this.synthMasterVolume;
        return this.synthBuffer;
    }

    @Override
    public float[] peek() {
        return this.synthBuffer;
    }

    public PlayingNote play(float freq) throws IllegalStateException {
        float[] freqs = new float[]{freq};
        return this.play(freqs, 1.0f, 0.0f, null);
    }

    public PlayingNote play(float freq, float volume) throws IllegalStateException {
        float[] freqs = new float[]{freq};
        return this.play(freqs, volume, 0.0f, null);
    }

    public PlayingNote play(float freq, float volume, float pan) throws IllegalStateException {
        float[] freqs = new float[]{freq};
        return this.play(freqs, volume, pan, null);
    }

    public PlayingNote play(float freq, NoteListener[] listeners) throws IllegalStateException {
        float[] freqs = new float[]{freq};
        return this.play(freqs, 1.0f, 0.0f, listeners);
    }

    public PlayingNote play(float freq, float volume, NoteListener[] listeners) throws IllegalStateException {
        float[] freqs = new float[]{freq};
        return this.play(freqs, volume, 0.0f, listeners);
    }

    public PlayingNote play(float freq, float volume, float pan, NoteListener[] listeners) {
        float[] freqs = new float[]{freq};
        return this.play(freqs, volume, pan, listeners);
    }

    @Override
    public PlayingNote play(float[] pitch, float volume, float pan, NoteListener[] listeners) {
        try {
            PolySynthNote note = this.getAvailableNote();
            note.setFrequency(pitch[0]);
            note.noteVolume = volume;
            note.pan = (pan + 1.0f) / 2.0f;
            note.play(listeners);
            return note;
        }
        catch (IllegalStateException arg0) {
            System.out.println(String.valueOf(this.synthName) + " note unavailable");
            return new BlankNote();
        }
    }

    protected PolySynthNote getAvailableNote() throws IllegalStateException {
        PolySynthNote[] polySynthNoteArray = this.notes;
        int n = this.notes.length;
        int n2 = 0;
        while (n2 < n) {
            PolySynthNote note = polySynthNoteArray[n2];
            if (note.isAvailable) {
                note.isAvailable = false;
                return note;
            }
            ++n2;
        }
        throw new IllegalStateException();
    }

    public void release(PlayingNote note) {
        note.release();
    }

    public void release(float freq) {
        PolySynthNote[] polySynthNoteArray = this.notes;
        int n = this.notes.length;
        int n2 = 0;
        while (n2 < n) {
            PolySynthNote note = polySynthNoteArray[n2];
            if (note.isPlaying && note.frequency == freq) {
                note.release();
            }
            ++n2;
        }
    }

    public void stop(PlayingNote note) {
        note.stop();
    }

    public void stopAll() {
        PolySynthNote[] polySynthNoteArray = this.notes;
        int n = this.notes.length;
        int n2 = 0;
        while (n2 < n) {
            PolySynthNote note = polySynthNoteArray[n2];
            note.stop();
            ++n2;
        }
    }

    public class BlankNote
    extends PolySynthNote
    implements PlayingNote {
        @Override
        protected PlayingNote play(NoteListener[] listeners) {
            return null;
        }

        @Override
        public void release() {
        }

        @Override
        protected void update() {
        }

        @Override
        public double getMainEnvelopeValue() {
            return 0.0;
        }

        @Override
        public boolean isPlaying() {
            return false;
        }

        @Override
        protected void setFrequency(float frequency) {
        }

        @Override
        protected void setModDepths() {
        }

        @Override
        protected void read(float[] synthBuffer) {
            synthBuffer[0] = 0.0f;
            synthBuffer[1] = 0.0f;
        }
    }

    public abstract class PolySynthNote
    implements PlayingNote {
        protected float frequency;
        protected float noteVolume;
        protected float pan;
        protected volatile boolean isPlaying = false;
        protected volatile boolean isReleasing;
        protected volatile boolean isAvailable = false;
        protected EnvelopeDataSet eds;
        protected float[] modDepths;
        protected volatile Envelope[] currentCarrierEnvelopes;
        protected volatile Envelope[] currentModulatorEnvelopes;
        protected EnvCursor[] carrierEnvCursors;
        protected EnvCursor[] modEnvCursors;
        protected EnvCursor primaryEnvCursor;
        protected NoteListener[] listeners = new NoteListener[0];

        @Override
        public boolean isPlaying() {
            return this.isPlaying;
        }

        protected PolySynthNote() {
            this.eds = PolySynth.this.edsUse;
            this.currentCarrierEnvelopes = new Envelope[this.eds.carrierEnvCount];
            this.currentModulatorEnvelopes = new Envelope[this.eds.modulatorEnvCount];
            this.carrierEnvCursors = new EnvCursor[this.eds.carrierEnvCount];
            this.modEnvCursors = new EnvCursor[this.eds.modulatorEnvCount];
            this.populateEnvCursors();
            this.setCursorsToStartValues();
        }

        protected PlayingNote play(NoteListener[] listeners) {
            this.eds = PolySynth.this.edsUse;
            int i = 0;
            while (i < this.eds.carrierEnvCount) {
                this.currentCarrierEnvelopes[i] = new Envelope(this.eds.getCarrierEnvelope(i));
                ++i;
            }
            i = 0;
            while (i < this.eds.modulatorEnvCount) {
                this.currentModulatorEnvelopes[i] = new Envelope(this.eds.getModulatorEnvelope(i));
                ++i;
            }
            this.setCursorsToStartValues();
            this.setEnvCursorStepsAndIncrements();
            if (listeners != null) {
                this.listeners = listeners;
                NoteListener[] noteListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    NoteListener nl = noteListenerArray[n2];
                    nl.noteStart(new PlayableNoteEvent(this));
                    ++n2;
                }
            } else {
                this.listeners = new NoteListener[0];
            }
            this.isReleasing = false;
            this.isPlaying = true;
            return this;
        }

        protected abstract void setFrequency(float var1);

        protected abstract void setModDepths();

        @Override
        public void updateVolume(float normalizedFloat) {
            System.out.println("CoreSynthNote.updateVolume is unimplemented");
            this.noteVolume = normalizedFloat;
        }

        @Override
        public void updatePan(float normalizedFloat) {
            System.out.println("CoreSynthNote.updatePan is unimplemented");
        }

        protected void populateEnvCursors() {
            int i = 0;
            while (i < this.eds.carrierEnvCount) {
                this.carrierEnvCursors[i] = new EnvCursor();
                ++i;
            }
            i = 0;
            while (i < this.eds.modulatorEnvCount) {
                this.modEnvCursors[i] = new EnvCursor();
                ++i;
            }
        }

        protected void setCursorsToStartValues() {
            int i = 0;
            while (i < this.eds.carrierEnvCount) {
                this.carrierEnvCursors[i].value = this.eds.getCarrierStartingValue(i);
                ++i;
            }
            i = 0;
            while (i < this.eds.modulatorEnvCount) {
                this.modEnvCursors[i].value = this.eds.getModulatorStartingValue(i);
                ++i;
            }
        }

        protected void setEnvCursorStepsAndIncrements() {
            int i = 0;
            while (i < this.eds.carrierEnvCount) {
                this.currentCarrierEnvelopes[i].initializeCursor(this.carrierEnvCursors[i], this.frequency);
                ++i;
            }
            i = 0;
            while (i < this.eds.modulatorEnvCount) {
                this.currentModulatorEnvelopes[i].initializeCursor(this.modEnvCursors[i], this.frequency);
                ++i;
            }
        }

        @Override
        public void release() {
            if (this.isPlaying && !this.isReleasing) {
                this.isReleasing = true;
                int i = 0;
                while (i < this.eds.carrierEnvCount) {
                    this.currentCarrierEnvelopes[i] = new Envelope(this.eds.getCarrierReleaseEnvelope(i));
                    ++i;
                }
                i = 0;
                while (i < this.eds.modulatorEnvCount) {
                    this.currentModulatorEnvelopes[i] = new Envelope(this.eds.getModulatorReleaseEnvelope(i));
                    ++i;
                }
                this.setEnvCursorStepsAndIncrements();
                NoteListener[] noteListenerArray = this.listeners;
                int n = this.listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    NoteListener nl = noteListenerArray[n2];
                    nl.noteRelease(new PlayableNoteEvent(this));
                    ++n2;
                }
            }
        }

        @Override
        public void stop() {
            this.isPlaying = false;
            this.isAvailable = true;
            NoteListener[] noteListenerArray = this.listeners;
            int n = this.listeners.length;
            int n2 = 0;
            while (n2 < n) {
                NoteListener nl = noteListenerArray[n2];
                nl.noteEnd(new PlayableNoteEvent(this));
                ++n2;
            }
        }

        protected void update() {
            if (this.primaryEnvCursor.value == 0.0 || this.isReleasing) {
                this.stop();
            }
        }

        protected abstract void read(float[] var1);

        @Override
        public double getMainEnvelopeValue() {
            return this.primaryEnvCursor.value;
        }
    }
}

