/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.synthParts;

public class VolumeMap {
    private final float[] mapData;
    private final int mapSize;

    public VolumeMap(float[] mapData) {
        this.mapData = mapData;
        this.mapSize = mapData.length - 2;
    }

    public float get(float i) {
        try {
            float v = i * (float)this.mapSize;
            int idx = (int)v;
            if (idx < 0) {
                idx = 0;
            }
            return this.mapData[idx + 1] * (v - (float)idx) + this.mapData[idx] * ((float)(idx + 1) - v);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("error, VolumeMap, input to get:" + i);
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public float get(double val) {
        val = Math.min(1.0, Math.max(0.0, val));
        double pointer = val * (double)this.mapSize;
        int ptrInt = (int)pointer;
        double frac = pointer - (double)ptrInt;
        return (float)((double)this.mapData[ptrInt] * (1.0 - frac) + (double)this.mapData[ptrInt + 1] * frac);
    }
}

