/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.synthParts;

import com.adonax.pfaudio.synthParts.VolumeMap;

public class VolumeMapMaker {
    private static final int VOLUME_MAP_SIZE = 257;

    public static float[] makeLinearVolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            audioData[i] = (float)((double)i / denominator);
            ++i;
        }
        return audioData;
    }

    public static float[] makeReverseCosVolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            audioData[i] = 1.0f - (float)Math.cos((double)i * Math.PI / (2.0 * denominator));
            ++i;
        }
        return audioData;
    }

    public static float[] makeSinPanMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            audioData[i] = (float)Math.sin((double)i * Math.PI / (2.0 * denominator));
            System.out.println("i:" + i + " f(i):" + audioData[i]);
            ++i;
        }
        return audioData;
    }

    public static float[] makeExp2VolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)Math.pow(2.0, x) - 1.0f;
            ++i;
        }
        return audioData;
    }

    public static float[] makeExp10VolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)((Math.pow(10.0, x) - 1.0) / 9.0);
            ++i;
        }
        return audioData;
    }

    public static float[] makeExp20VolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)((Math.pow(20.0, x) - 1.0) / 19.0);
            ++i;
        }
        return audioData;
    }

    public static float[] makeX2VolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)Math.pow(x, 2.0);
            ++i;
        }
        return audioData;
    }

    public static float[] makeX3VolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)Math.pow(x, 3.0);
            ++i;
        }
        return audioData;
    }

    public static float[] makeX4VolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)Math.pow(x, 4.0);
            ++i;
        }
        return audioData;
    }

    public static float[] makeInverseX4VolMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (denominator - (double)i) / denominator;
            audioData[i] = 1.0f - (float)Math.pow(x, 4.0);
            ++i;
        }
        return audioData;
    }

    public static float[] makeX5VolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)Math.pow(x, 5.0);
            ++i;
        }
        return audioData;
    }

    public static float[] makeX6VolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)Math.pow(x, 6.0);
            ++i;
        }
        return audioData;
    }

    public static float[] makeX7VolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)Math.pow(x, 7.0);
            ++i;
        }
        return audioData;
    }

    public static float[] makeX10VolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)Math.pow(x, 10.0);
            ++i;
        }
        return audioData;
    }

    public static float[] makeIans3223VolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)(3.0 * x * x - 2.0 * x * x * x);
            ++i;
        }
        return audioData;
    }

    public static float[] makeProportionalVolumeMap() {
        float[] audioData = new float[257];
        double denominator = 255.0;
        int i = 0;
        while (i < 257) {
            double x = (double)i / denominator;
            audioData[i] = (float)Math.pow(x, Math.E);
            ++i;
        }
        return audioData;
    }

    public static float[] makeOctaveMap(int octaves) {
        float[] audioData = new float[257];
        double factor = (double)octaves / 255.0;
        int i = 0;
        while (i < 257) {
            audioData[i] = (float)Math.pow(2.0, (float)((double)i * factor));
            ++i;
        }
        return audioData;
    }

    public static float[] makeSimplexNoiseVolumeMap() {
        float[] audioData = new float[257];
        double denominator = 287.0;
        int i = 0;
        while (i < 257) {
            double x = 11.0 - (double)(11 * i) / denominator;
            audioData[i] = (float)Math.pow(2.0, -x);
            ++i;
        }
        return audioData;
    }

    public static float[] makeShepardToneMap(int octaves) {
        VolumeMap volMap = new VolumeMap(VolumeMapMaker.makeExp2VolumeMap());
        float[] audioData = new float[257];
        int i = 0;
        while (i < 257) {
            audioData[i] = 1.0f;
            ++i;
        }
        audioData[256] = 0.0f;
        i = 0;
        int n = 256 / octaves;
        double incr = 1.0 / (double)n;
        while (i < n) {
            audioData[i] = volMap.get((double)i * incr);
            audioData[257 - (i + 2)] = audioData[i];
            ++i;
        }
        return audioData;
    }

    public static void main(String[] args) {
        VolumeMapMaker.makeInverseX4VolMap();
    }
}

