/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.synthParts;

public class WaveTableMaker {
    private static final int WAVE_TABLE_SIZE = 1025;

    public static float[] makeSineWaveTable() {
        float[] audioData = new float[1025];
        int i = 0;
        while (i < 1025) {
            audioData[i] = (float)Math.sin((double)(2 * i) * 0.0030679615757712823);
            ++i;
        }
        return audioData;
    }

    public static float[] makeGeneratedSquareWT(int harmonics) {
        float[] audioData = new float[1025];
        int upperBound = harmonics * 2;
        float jDenom = 0.0f;
        int i = 0;
        while (i < harmonics) {
            jDenom += (float)(i + 1);
            ++i;
        }
        System.out.println("JDenom:" + jDenom);
        int j = 1;
        while (j < upperBound) {
            System.out.println("j/jDenom:" + j + " " + (float)((j + 1) / 2) / jDenom);
            int i2 = 0;
            while (i2 < 1025) {
                int n = 1024 - i2;
                audioData[n] = audioData[n] + (float)Math.sin((double)(2 * j * i2) * 0.0030679615757712823) * ((float)((j + 1) / 2) / jDenom);
                ++i2;
            }
            j += 2;
        }
        return audioData;
    }

    public static double[] makeLargeSineWT() {
        double[] audioData = new double[8193];
        int i = 0;
        while (i < 8193) {
            audioData[i] = Math.sin(2.0 * (double)i * 3.834951969714103E-4);
            ++i;
        }
        return audioData;
    }

    public static double[] makeLargeCosWT() {
        double[] audioData = new double[8193];
        int i = 0;
        while (i < 8193) {
            audioData[i] = Math.cos(2.0 * (double)i * 3.834951969714103E-4);
            ++i;
        }
        return audioData;
    }

    public static float[] makeSawtoothWaveTable() {
        float[] audioData = new float[1025];
        float n = 1024.0f;
        int i = 0;
        while (i < 1025) {
            audioData[i] = (n - (float)(i * 2)) / n;
            ++i;
        }
        audioData[1024] = audioData[0];
        return audioData;
    }

    public static float[] makeSquareWaveTable() {
        float[] audioData = new float[1025];
        int halfway = 512;
        int i = 0;
        while (i < halfway) {
            audioData[i] = 1.0f;
            ++i;
        }
        i = halfway;
        while (i < 1025) {
            audioData[i] = -1.0f;
            ++i;
        }
        audioData[1024] = audioData[0];
        return audioData;
    }

    public static float[] makePulseWaveTable() {
        float[] audioData = new float[1025];
        int i = 0;
        while (i < 64) {
            audioData[i] = 1.0f;
            ++i;
        }
        i = 64;
        while (i < 1025) {
            audioData[i] = -1.0f;
            ++i;
        }
        audioData[1024] = audioData[0];
        return audioData;
    }

    public static float[] makeStaticWaveTable() {
        float[] audioData = new float[1025];
        int i = 0;
        while (i < 1025) {
            audioData[i] = (float)(Math.random() * 2.0 - 1.0);
            ++i;
        }
        audioData[1024] = audioData[0];
        return audioData;
    }
}

