/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.pfaudio.synthesizers;

import com.adonax.pfaudio.events.NoteListener;
import com.adonax.pfaudio.events.PlayableNoteEvent;
import com.adonax.pfaudio.events.PlayingNote;
import com.adonax.pfaudio.synthParts.EnvCursor;
import com.adonax.pfaudio.synthParts.Envelope;
import com.adonax.pfaudio.synthParts.FMOp;
import com.adonax.pfaudio.synthParts.OpN;
import com.adonax.pfaudio.synthParts.OpPML;
import com.adonax.pfaudio.synthParts.PolySynth;
import com.adonax.pfaudio.synthesizers.envelopes.DinkSynth_MainEnv;

public class DinkSynth2
extends PolySynth {
    private float carrierFrequency;
    private float carrierFreqSweepFactor = 1.0f;
    private float lfoFrequency;
    private final int LFO_AMPLITUDE_MAX = 2000;
    private float lfoAmplitude;
    private float lfoFreqSweepFactor = 1.0f;
    private LFOTarget lfoTarget = LFOTarget.VIBRATO;
    private float modulatorFrequency;
    private ModulatorPitchMode modulatorPitchMode = ModulatorPitchMode.ABSOLUTE;
    private final int MODULATOR_INDEX_MAX = 4000;
    private float modulatorIndex;
    private float modulatorIndexSweepFactor = 1.0f;
    private boolean modulatorUsesCarrierEnvelope;

    public void setCarrierFrequency(float hertz) {
        this.carrierFrequency = hertz;
    }

    public void setCarrierFreqSweepFactor(float valueNormal) {
        this.carrierFreqSweepFactor = 1.0f + valueNormal * 1.0E-4f;
    }

    public void setLFOFrequency(float hertz) {
        this.lfoFrequency = hertz;
    }

    public void setLFOAmplitude(float valueNormal) {
        this.lfoAmplitude = valueNormal * 2000.0f;
    }

    public void setLfoFreqSweepFactor(float valueNormal) {
        this.lfoFreqSweepFactor = 1.0f + valueNormal * 1.0E-4f;
        System.out.println("DS2.setLFOSweepFactor:" + this.lfoFreqSweepFactor);
    }

    public void setLFOTarget(LFOTarget lfoTarget) {
        this.lfoTarget = lfoTarget;
    }

    public void setModulatorFrequency(float hertz) {
        this.modulatorFrequency = hertz;
    }

    public void setModulatorPitchMode(ModulatorPitchMode modulatorPitchMode) {
        this.modulatorPitchMode = modulatorPitchMode;
    }

    public void setModulatorIndex(float normal) {
        this.modulatorIndex = normal * 4000.0f;
    }

    public void setModulatorIndexSweepFactor(float valueNormal) {
        this.modulatorIndexSweepFactor = 1.0f + valueNormal * 0.001f;
    }

    public void setModulatorUsesCarrierEnvelope(boolean bool) {
        this.modulatorUsesCarrierEnvelope = bool;
    }

    public DinkSynth2(int polyphony) {
        this.synthName = "DinkSynth";
        this.MAX_VOLUME = 0.35f;
        this.setVolume(1.0f);
        this.edsUse = new DinkSynth_MainEnv();
        this.notes = new DinkNote[polyphony];
        int i = 0;
        while (i < polyphony) {
            this.notes[i] = new DinkNote(this);
            ++i;
        }
        this.running = true;
    }

    class DinkNote
    extends PolySynth.PolySynthNote {
        private DinkSynth2 parent;
        private final FMOp cOp0;
        private final FMOp mOp0;
        private final FMOp lfoOp;
        private float carrierFreq;
        private float modulatorFreq;
        private float lfoFrequency;
        private float carrierFreqFactor;
        private float modulatorRelativeFreqFactor;
        private float carrierEnvVal;
        private float modulatorIndex;
        private float modulatorEnvVal;
        private ModulatorPitchMode modulatorPitchMode;
        private float modulatorIndexSweepFactor;
        private boolean modulatorDepthTracksCarrierEnv;
        private float lfoVal;
        private float lfoAmplitude;
        private float lfoFreqSweepFactor;
        private LFOTarget lfoTarget;

        DinkNote(DinkSynth2 parent) {
            super(DinkSynth2.this);
            this.carrierFreqFactor = 1.0f;
            this.modulatorIndexSweepFactor = 1.0f;
            this.lfoFreqSweepFactor = 1.0f;
            this.parent = parent;
            this.currentCarrierEnvelopes = new Envelope[this.eds.carrierEnvCount];
            this.carrierEnvCursors = new EnvCursor[this.eds.carrierEnvCount];
            this.cOp0 = new OpPML();
            this.mOp0 = new OpN();
            this.lfoOp = new OpN();
            this.populateEnvCursors();
            this.setCursorsToStartValues();
            this.primaryEnvCursor = this.carrierEnvCursors[0];
            this.isAvailable = true;
        }

        @Override
        protected PlayingNote play(NoteListener[] listeners) {
            this.eds = DinkSynth2.this.edsUse;
            int i = 0;
            while (i < this.eds.carrierEnvCount) {
                this.currentCarrierEnvelopes[i] = new Envelope(this.eds.getCarrierEnvelope(i));
                ++i;
            }
            i = 0;
            while (i < this.eds.modulatorEnvCount) {
                this.currentModulatorEnvelopes[i] = new Envelope(this.eds.getModulatorEnvelope(i));
                ++i;
            }
            this.setCursorsToStartValues();
            this.setEnvCursorStepsAndIncrements();
            this.cOp0.setFrequency(this.carrierFreq, 0.0f);
            this.carrierFreqFactor = this.parent.carrierFreqSweepFactor;
            this.lfoFrequency = this.parent.lfoFrequency;
            this.lfoOp.setFrequency(this.lfoFrequency, 0.0f);
            this.lfoAmplitude = this.parent.lfoAmplitude;
            this.lfoFreqSweepFactor = this.parent.lfoFreqSweepFactor;
            this.modulatorPitchMode = this.parent.modulatorPitchMode;
            switch (this.modulatorPitchMode) {
                case RELATIVE: {
                    this.modulatorRelativeFreqFactor = this.parent.modulatorFrequency;
                    this.modulatorFreq = this.carrierFreq * this.modulatorRelativeFreqFactor;
                    break;
                }
                case ABSOLUTE: {
                    this.modulatorFreq = this.parent.modulatorFrequency;
                }
            }
            this.mOp0.setFrequency(this.modulatorFreq, 0.0f);
            this.lfoTarget = this.parent.lfoTarget;
            System.out.println("DinkSynthNote.carrierFreq:" + this.carrierFreq);
            System.out.println("DinkSynthNote.modulatorHz:" + this.modulatorFreq);
            this.modulatorIndex = this.parent.modulatorIndex;
            System.out.println("DinkSynthNote.modulatorIndex:" + this.modulatorIndex);
            this.modulatorIndexSweepFactor = this.parent.modulatorIndexSweepFactor;
            this.modulatorDepthTracksCarrierEnv = this.parent.modulatorUsesCarrierEnvelope;
            if (listeners != null) {
                this.listeners = listeners;
                NoteListener[] noteListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    NoteListener nl = noteListenerArray[n2];
                    nl.noteStart(new PlayableNoteEvent(this));
                    ++n2;
                }
            } else {
                this.listeners = new NoteListener[0];
            }
            this.isReleasing = false;
            this.isPlaying = true;
            return this;
        }

        @Override
        protected void setFrequency(float factor) {
            this.frequency = this.carrierFreq = this.parent.carrierFrequency * factor;
            this.cOp0.setFrequency(this.carrierFreq);
        }

        @Override
        protected void setModDepths() {
        }

        private void updateSweeps() {
            this.carrierFreq *= this.carrierFreqFactor;
            this.cOp0.setFrequency(this.carrierFreq);
            if (this.modulatorPitchMode == ModulatorPitchMode.RELATIVE) {
                this.mOp0.setFrequency(this.carrierFreq * this.modulatorRelativeFreqFactor);
            }
            this.modulatorIndex *= this.modulatorIndexSweepFactor;
            this.modulatorIndex = Math.min(4000.0f, this.modulatorIndex);
            this.lfoFrequency *= this.lfoFreqSweepFactor;
            this.lfoOp.setFrequency(this.lfoFrequency);
        }

        @Override
        protected void read(float[] synthBuffer) {
            try {
                if (this.isPlaying) {
                    this.updateSweeps();
                    this.lfoVal = this.lfoOp.get();
                    this.currentCarrierEnvelopes[0].tick(this.carrierEnvCursors[0], this.carrierFreq);
                    this.carrierEnvVal = DinkSynth2.this.vmCarrier.get(this.carrierEnvCursors[0].value);
                    this.modulatorEnvVal = this.modulatorDepthTracksCarrierEnv ? this.carrierEnvVal : 1.0f;
                    float modulatorPart = this.mOp0.get() * this.modulatorEnvVal * this.modulatorIndex;
                    if (this.lfoTarget == LFOTarget.VIBRATO) {
                        modulatorPart += this.lfoVal * this.lfoAmplitude;
                    }
                    float noteVal = this.carrierEnvVal * this.cOp0.get(modulatorPart);
                    if (this.lfoTarget == LFOTarget.TREMOLO) {
                        noteVal *= this.lfoVal / 2.0f + 0.5f;
                    }
                    if (this.primaryEnvCursor.done) {
                        this.update();
                    }
                    synthBuffer[1] = synthBuffer[1] + noteVal * this.noteVolume * this.pan;
                    synthBuffer[0] = synthBuffer[0] + noteVal * this.noteVolume * (1.0f - this.pan);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
    }

    public static enum LFOTarget {
        TREMOLO,
        VIBRATO;

    }

    public static enum ModulatorPitchMode {
        ABSOLUTE,
        RELATIVE;

    }
}

